/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000fJ#\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0014J\r\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0004R&\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/dediamondpro/resourcify/util/Cache;", "T", "", "<init>", "()V", "", "identifier", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "Ljava/net/URI;", "(Ljava/net/URI;)Ljava/lang/Object;", "image", "", "put", "(Ljava/lang/String;Ljava/lang/Object;)V", "(Ljava/net/URI;Ljava/lang/Object;)V", "Lkotlin/Function0;", "imageSupplier", "getOrPut", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Ljava/net/URI;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clear", "", "Ljava/lang/ref/WeakReference;", "cache", "Ljava/util/Map;", "Resourcify (1.21.1-neoforge)-1.8.0"})
@SourceDebugExtension(value={"SMAP\nImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageCache.kt\ndev/dediamondpro/resourcify/util/Cache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public abstract class Cache<T> {
    @NotNull
    private final Map<String, WeakReference<T>> cache = new ConcurrentHashMap();

    @Nullable
    public final T get(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        WeakReference<T> weakReference = this.cache.get(identifier);
        if (weakReference == null) {
            return null;
        }
        WeakReference<T> ref = weakReference;
        Object cached = ref.get();
        if (cached == null) {
            this.cache.remove(identifier);
        }
        return cached;
    }

    @Nullable
    public final T get(@NotNull URI identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        String string = identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.get(string);
    }

    public final void put(@NotNull String identifier, T image) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.cache.put(identifier, new WeakReference<T>(image));
    }

    public final void put(@NotNull URI identifier, T image) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        String string = identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.put(string, image);
    }

    public final T getOrPut(@NotNull String identifier, @NotNull Function0<? extends T> imageSupplier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(imageSupplier, (String)"imageSupplier");
        Object object = this.get(identifier);
        if (object == null) {
            Object object2;
            Object it = object2 = imageSupplier.invoke();
            boolean bl = false;
            this.put(identifier, it);
            object = object2;
        }
        return object;
    }

    public final T getOrPut(@NotNull URI identifier, @NotNull Function0<? extends T> imageSupplier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(imageSupplier, (String)"imageSupplier");
        String string = identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.getOrPut(string, imageSupplier);
    }

    public final void clear() {
        this.cache.clear();
    }
}

