/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.internal;

import dev.dediamondpro.resourcify.libs.commonmark.internal.util.Parsing;
import dev.dediamondpro.resourcify.libs.commonmark.node.Block;
import dev.dediamondpro.resourcify.libs.commonmark.node.BlockQuote;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParserFactory;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockContinue;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockStart;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.MatchedBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.ParserState;

public class BlockQuoteParser
extends AbstractBlockParser {
    private final BlockQuote block = new BlockQuote();

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        return true;
    }

    @Override
    public BlockQuote getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        if (BlockQuoteParser.isMarker(state, nextNonSpace)) {
            int newColumn = state.getColumn() + state.getIndent() + 1;
            if (Parsing.isSpaceOrTab(state.getLine().getContent(), nextNonSpace + 1)) {
                ++newColumn;
            }
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    private static boolean isMarker(ParserState state, int index) {
        CharSequence line = state.getLine().getContent();
        return state.getIndent() < Parsing.CODE_BLOCK_INDENT && index < line.length() && line.charAt(index) == '>';
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            if (BlockQuoteParser.isMarker(state, nextNonSpace)) {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab(state.getLine().getContent(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new BlockQuoteParser()).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }
}

