/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinButton;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.IExtendedWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedButton
extends Button
implements IExtendedWidget,
UniqueWidget,
NavigatableWidget,
FancyMenuWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.parse((String)"widget/button"), ResourceLocation.parse((String)"widget/button_disabled"), ResourceLocation.parse((String)"widget/button_highlighted"));
    protected final Minecraft mc = Minecraft.getInstance();
    protected boolean enableLabel = true;
    protected DrawableColor labelBaseColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    protected DrawableColor labelBaseColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @NotNull
    protected ConsumingSupplier<ExtendedButton, Component> labelSupplier = consumes -> Component.empty();
    protected ConsumingSupplier<ExtendedButton, Tooltip> tooltipSupplier = null;
    protected boolean forceDefaultTooltipStyle = false;
    @Nullable
    protected DrawableColor backgroundColorNormal;
    @Nullable
    protected DrawableColor backgroundColorHover;
    @Nullable
    protected DrawableColor backgroundColorInactive;
    @Nullable
    protected DrawableColor borderColorNormal;
    @Nullable
    protected DrawableColor borderColorHover;
    @Nullable
    protected DrawableColor borderColorInactive;
    @Nullable
    protected ConsumingSupplier<ExtendedButton, Boolean> activeSupplier;
    protected boolean focusable = true;
    protected boolean navigatable = true;
    @Nullable
    protected String identifier;

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.literal((String)""), onPress, DEFAULT_NARRATION);
        this.setLabel((Component)Component.literal((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull Button.OnPress onPress, Button.CreateNarration narration) {
        super(x, y, width, height, (Component)Component.literal((String)""), onPress, narration);
        this.setLabel((Component)Component.literal((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull Component label, @NotNull Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.literal((String)""), onPress, DEFAULT_NARRATION);
        this.setLabel(label);
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull Component label, @NotNull Button.OnPress onPress, Button.CreateNarration narration) {
        super(x, y, width, height, (Component)Component.literal((String)""), onPress, narration);
        this.setLabel(label);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateIsActive();
        this.updateLabel();
        Tooltip tooltip = this.getTooltipFancyMenu();
        if (tooltip != null && this.isHovered() && this.visible) {
            if (this.forceDefaultTooltipStyle) {
                tooltip.setDefaultStyle();
            }
            TooltipHandler.INSTANCE.addTooltip(tooltip, () -> true, false, true);
        }
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(graphics);
        this.renderLabelText(graphics);
    }

    protected void renderBackground(@NotNull GuiGraphics graphics) {
        if (this.getExtendedAsCustomizableWidget().renderCustomBackgroundFancyMenu((AbstractWidget)this, graphics, this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            if (this.renderColorBackground(graphics)) {
                graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                graphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
                RenderingUtils.resetShaderColor(graphics);
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected boolean renderColorBackground(@NotNull GuiGraphics graphics) {
        RenderSystem.enableBlend();
        if (this.active) {
            if (this.isHoveredOrFocused()) {
                if (this.backgroundColorHover != null) {
                    graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.backgroundColorHover.getColorInt());
                    if (this.borderColorHover != null) {
                        UIBase.renderBorder(graphics, (float)this.getX(), (float)this.getY(), (float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight()), 1.0f, this.borderColorHover.getColorInt(), true, true, true, true);
                    }
                    return false;
                }
            } else if (this.backgroundColorNormal != null) {
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.backgroundColorNormal.getColorInt());
                if (this.borderColorNormal != null) {
                    UIBase.renderBorder(graphics, (float)this.getX(), (float)this.getY(), (float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight()), 1.0f, this.borderColorNormal.getColorInt(), true, true, true, true);
                }
                return false;
            }
        } else if (this.backgroundColorInactive != null) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.backgroundColorInactive.getColorInt());
            if (this.borderColorInactive != null) {
                UIBase.renderBorder(graphics, (float)this.getX(), (float)this.getY(), (float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight()), 1.0f, this.borderColorInactive.getColorInt(), true, true, true, true);
            }
            return false;
        }
        return true;
    }

    protected void renderLabelText(@NotNull GuiGraphics graphics) {
        if (this.enableLabel) {
            int k = this.active ? this.labelBaseColorNormal.getColorIntWithAlpha(this.alpha) : this.labelBaseColorInactive.getColorIntWithAlpha(this.alpha);
            this.renderScrollingLabel((AbstractWidget)this, graphics, this.mc.font, 2, this.labelShadow, k);
        }
    }

    protected void updateLabel() {
        Component c = this.labelSupplier.get(this);
        if (c == null) {
            c = Component.literal((String)"");
        }
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(c);
    }

    protected void updateIsActive() {
        Boolean b;
        if (this.activeSupplier != null && (b = this.activeSupplier.get(this)) != null) {
            this.active = b;
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected int getHoverState() {
        if (this.isHovered) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

    @Nullable
    public ConsumingSupplier<ExtendedButton, Tooltip> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public ExtendedButton setTooltipSupplier(@Nullable ConsumingSupplier<ExtendedButton, Tooltip> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    @Nullable
    public Tooltip getTooltipFancyMenu() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get(this);
        }
        return null;
    }

    public ExtendedButton setTooltip(@Nullable Tooltip tooltip) {
        this.tooltipSupplier = tooltip == null ? null : button -> tooltip;
        return this;
    }

    public boolean isForceDefaultTooltipStyle() {
        return this.forceDefaultTooltipStyle;
    }

    public ExtendedButton setForceDefaultTooltipStyle(boolean forceDefaultTooltipStyle) {
        this.forceDefaultTooltipStyle = forceDefaultTooltipStyle;
        return this;
    }

    @Deprecated
    public void setMessage(@NotNull Component msg) {
        this.setLabel(msg);
    }

    @Deprecated
    @NotNull
    public Component getMessage() {
        return super.getMessage();
    }

    public ExtendedButton setLabel(@NotNull Component label) {
        this.labelSupplier = btn -> label;
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(label);
        return this;
    }

    public ExtendedButton setLabel(@NotNull String label) {
        this.labelSupplier = btn -> Component.literal((String)label);
        return this;
    }

    public ExtendedButton setLabelSupplier(@NotNull ConsumingSupplier<ExtendedButton, Component> labelSupplier) {
        this.labelSupplier = labelSupplier;
        this.updateLabel();
        return this;
    }

    @NotNull
    public ConsumingSupplier<ExtendedButton, Component> getLabelSupplier() {
        return this.labelSupplier;
    }

    @NotNull
    public Component getLabel() {
        Component c = this.getLabelSupplier().get(this);
        if (c == null) {
            c = Component.empty();
        }
        return c;
    }

    public boolean isLabelEnabled() {
        return this.enableLabel;
    }

    public ExtendedButton setLabelEnabled(boolean enabled) {
        this.enableLabel = enabled;
        return this;
    }

    public DrawableColor getLabelBaseColorNormal() {
        return this.labelBaseColorNormal;
    }

    public void setLabelBaseColorNormal(DrawableColor labelBaseColorNormal) {
        this.labelBaseColorNormal = labelBaseColorNormal;
    }

    public DrawableColor getLabelBaseColorInactive() {
        return this.labelBaseColorInactive;
    }

    public void setLabelBaseColorInactive(DrawableColor labelBaseColorInactive) {
        this.labelBaseColorInactive = labelBaseColorInactive;
    }

    public boolean isLabelShadowEnabled() {
        return this.labelShadow;
    }

    public ExtendedButton setLabelShadowEnabled(boolean enabled) {
        this.labelShadow = enabled;
        return this;
    }

    public ExtendedButton setIsActiveSupplier(@Nullable ConsumingSupplier<ExtendedButton, Boolean> isActiveSupplier) {
        this.activeSupplier = isActiveSupplier;
        return this;
    }

    @Nullable
    public ConsumingSupplier<ExtendedButton, Boolean> getIsActiveSupplier() {
        return this.activeSupplier;
    }

    @Nullable
    public DrawableColor getBackgroundColorNormal() {
        return this.backgroundColorNormal;
    }

    public void setBackgroundColor(@Nullable DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor borderColorNormal, @Nullable DrawableColor borderColorHover, @Nullable DrawableColor borderColorInactive) {
        this.backgroundColorNormal = backgroundColorNormal;
        this.backgroundColorHover = backgroundColorHover;
        this.backgroundColorInactive = backgroundColorInactive;
        this.borderColorNormal = borderColorNormal;
        this.borderColorHover = borderColorHover;
        this.borderColorInactive = borderColorInactive;
    }

    public void setBackgroundColorNormal(@Nullable DrawableColor backgroundColorNormal) {
        this.backgroundColorNormal = backgroundColorNormal;
    }

    @Nullable
    public DrawableColor getBackgroundColorHover() {
        return this.backgroundColorHover;
    }

    public void setBackgroundColorHover(@Nullable DrawableColor backgroundColorHover) {
        this.backgroundColorHover = backgroundColorHover;
    }

    @Nullable
    public DrawableColor getBackgroundColorInactive() {
        return this.backgroundColorInactive;
    }

    public void setBackgroundColorInactive(@Nullable DrawableColor backgroundColorInactive) {
        this.backgroundColorInactive = backgroundColorInactive;
    }

    @Nullable
    public DrawableColor getBorderColorNormal() {
        return this.borderColorNormal;
    }

    public void setBorderColorNormal(@Nullable DrawableColor borderColorNormal) {
        this.borderColorNormal = borderColorNormal;
    }

    @Nullable
    public DrawableColor getBorderColorHover() {
        return this.borderColorHover;
    }

    public void setBorderColorHover(@Nullable DrawableColor borderColorHover) {
        this.borderColorHover = borderColorHover;
    }

    @Nullable
    public DrawableColor getBorderColorInactive() {
        return this.borderColorInactive;
    }

    public void setBorderColorInactive(@Nullable DrawableColor borderColorInactive) {
        this.borderColorInactive = borderColorInactive;
    }

    @Nullable
    public RenderableResource getBackgroundNormal() {
        return this.getExtendedAsCustomizableWidget().getCustomBackgroundNormalFancyMenu();
    }

    public ExtendedButton setBackgroundNormal(@Nullable RenderableResource background) {
        this.getExtendedAsCustomizableWidget().setCustomBackgroundNormalFancyMenu(background);
        return this;
    }

    @Nullable
    public RenderableResource getBackgroundHover() {
        return this.getExtendedAsCustomizableWidget().getCustomBackgroundHoverFancyMenu();
    }

    public ExtendedButton setBackgroundHover(@Nullable RenderableResource background) {
        this.getExtendedAsCustomizableWidget().setCustomBackgroundHoverFancyMenu(background);
        return this;
    }

    @Nullable
    public RenderableResource getBackgroundInactive() {
        return this.getExtendedAsCustomizableWidget().getCustomBackgroundInactiveFancyMenu();
    }

    public ExtendedButton setBackgroundInactive(@Nullable RenderableResource background) {
        this.getExtendedAsCustomizableWidget().setCustomBackgroundInactiveFancyMenu(background);
        return this;
    }

    public Button.OnPress getPressAction() {
        return this.onPress;
    }

    public ExtendedButton setPressAction(@NotNull Button.OnPress pressAction) {
        ((IMixinButton)((Object)this)).setPressActionFancyMenu(pressAction);
        return this;
    }

    public CustomizableWidget getExtendedAsCustomizableWidget() {
        return (CustomizableWidget)((Object)this);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean isFocused() {
        if (!this.focusable) {
            return false;
        }
        return super.isFocused();
    }

    public void setFocused(boolean $$0) {
        if (!this.focusable) {
            super.setFocused(false);
            return;
        }
        super.setFocused($$0);
    }

    public ExtendedButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }
}

