/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.server;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.network.chat.Component;

public class ServerCache {
    protected static final Component CANT_CONNECT_TEXT = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(ChatFormatting.DARK_RED);
    protected static ServerStatusPinger pinger = new ServerStatusPinger();
    protected static Map<String, ServerData> servers = new HashMap<String, ServerData>();
    protected static Map<String, ServerData> serversUpdated = new HashMap<String, ServerData>();

    public static void init() {
        new Thread(() -> {
            while (true) {
                try {
                    if (ScreenCustomization.isCustomizationEnabledForScreen(Minecraft.getInstance().screen)) {
                        ServerCache.pingServers();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    public static void cacheServer(ServerData server, ServerData serverUpdated) {
        if (server.ip != null) {
            try {
                server.ping = -1L;
                serverUpdated.ping = -1L;
                servers.put(server.ip, server);
                serversUpdated.put(server.ip, serverUpdated);
                ServerCache.pingServers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ServerData getServer(String ip) {
        if (!servers.containsKey(ip)) {
            ServerCache.cacheServer(new ServerData(ip, ip, ServerData.Type.OTHER), new ServerData(ip, ip, ServerData.Type.OTHER));
        }
        if (ServerCache.servers.get((Object)ip).motd != null && !ServerCache.servers.get((Object)ip).motd.equals((Object)Component.translatable((String)"multiplayer.status.pinging"))) {
            ServerCache.serversUpdated.get((Object)ip).ping = ServerCache.servers.get((Object)ip).ping;
            ServerCache.serversUpdated.get((Object)ip).protocol = ServerCache.servers.get((Object)ip).protocol;
            ServerCache.serversUpdated.get((Object)ip).motd = ServerCache.servers.get((Object)ip).motd;
            ServerCache.serversUpdated.get((Object)ip).version = ServerCache.servers.get((Object)ip).version;
            ServerCache.serversUpdated.get((Object)ip).status = ServerCache.servers.get((Object)ip).status;
            ServerCache.serversUpdated.get((Object)ip).playerList = ServerCache.servers.get((Object)ip).playerList;
        }
        return serversUpdated.get(ip);
    }

    public static void removeServer(String ip) {
        servers.remove(ip);
        serversUpdated.remove(ip);
    }

    public static void clear() {
        servers.clear();
        serversUpdated.clear();
    }

    public static void pingServers() {
        ArrayList<ServerData> l = new ArrayList<ServerData>(servers.values());
        for (ServerData d : l) {
            try {
                new Thread(() -> {
                    try {
                        pinger.pingServer(d, () -> {}, () -> {});
                        if (d == null || d.status.getString().isEmpty()) {
                            d.ping = -1L;
                            d.motd = CANT_CONNECT_TEXT;
                        }
                    }
                    catch (Exception ex) {
                        d.ping = -1L;
                        d.motd = CANT_CONNECT_TEXT;
                    }
                }).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

