/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class AsyncPlaceholderErrorScreen
extends QueueableScreen {
    @NotNull
    protected Component placeholderName;
    protected List<FormattedCharSequence> renderText;

    protected AsyncPlaceholderErrorScreen(@NotNull Component placeholderName) {
        super((Component)Component.empty());
        this.placeholderName = placeholderName.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(UIBase.getUIColorTheme().error_text_color.getColorInt()));
    }

    @Override
    protected void init() {
        int centerX = this.width / 2;
        super.init();
        this.renderText = this.font.split((FormattedText)Component.translatable((String)"fancymenu.placeholders.async.cant_run_async", (Object[])new Object[]{this.placeholderName}), this.width - 60);
        UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(centerX - 100, this.height - 50, 200, 20, (Component)Component.translatable((String)"fancymenu.common_components.ok"), button -> this.onClose())));
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        if (this.renderText == null) {
            return;
        }
        Objects.requireNonNull(this.font);
        int lineHeight = 9 + 2;
        int totalTextHeight = this.renderText.size() * lineHeight;
        int renderY = centerY - totalTextHeight / 2;
        for (FormattedCharSequence s : this.renderText) {
            graphics.drawCenteredString(this.font, s, centerX, renderY, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
            renderY += lineHeight;
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int $$1, int $$2, float $$3) {
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color.getColorInt());
    }
}

