/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnWorldLeftListener
extends AbstractListener {
    @Nullable
    private String cachedWorldName;
    @Nullable
    private String cachedWorldSavePath;
    @Nullable
    private String cachedWorldDifficulty;
    @Nullable
    private String cachedWorldCheatsAllowed;
    @Nullable
    private String cachedWorldIconPath;

    public OnWorldLeftListener() {
        super("world_left");
    }

    public void onWorldLeft(@Nullable String worldName, @Nullable String worldSavePath, @Nullable String worldDifficultyKey, @Nullable String cheatsAllowed, @Nullable String worldIconPath) {
        this.cachedWorldName = OnWorldLeftListener.sanitize(worldName);
        this.cachedWorldSavePath = OnWorldLeftListener.sanitize(worldSavePath);
        this.cachedWorldDifficulty = OnWorldLeftListener.sanitize(worldDifficultyKey);
        this.cachedWorldCheatsAllowed = OnWorldLeftListener.sanitize(cheatsAllowed);
        this.cachedWorldIconPath = OnWorldLeftListener.sanitize(worldIconPath);
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("world_name", () -> OnWorldLeftListener.valueOrError(this.cachedWorldName)));
        list.add(new AbstractListener.CustomVariable("world_save_path", () -> OnWorldLeftListener.valueOrError(this.cachedWorldSavePath)));
        list.add(new AbstractListener.CustomVariable("world_difficulty", () -> OnWorldLeftListener.valueOrError(this.cachedWorldDifficulty)));
        list.add(new AbstractListener.CustomVariable("world_cheats_allowed", () -> OnWorldLeftListener.booleanString(this.cachedWorldCheatsAllowed)));
        list.add(new AbstractListener.CustomVariable("world_icon_path", () -> OnWorldLeftListener.valueOrError(this.cachedWorldIconPath)));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_world_left");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_world_left.desc", new String[0]));
    }

    private static String sanitize(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static String valueOrError(@Nullable String value) {
        return value != null ? value : "ERROR";
    }

    private static String booleanString(@Nullable String value) {
        if (value == null || value.isBlank()) {
            return "false";
        }
        return Boolean.toString(Boolean.parseBoolean(value));
    }
}

