/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtEntityListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnStopLookingAtEntityListener
extends AbstractListener {
    @Nullable
    private OnStartLookingAtEntityListener.LookedEntityData lastEntityData;

    public OnStopLookingAtEntityListener() {
        super("stop_looking_at_entity");
    }

    public void onStopLooking(@Nullable OnStartLookingAtEntityListener.LookedEntityData data) {
        this.lastEntityData = data;
        if (data != null) {
            this.notifyAllInstances();
        }
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null || data.entityKey() == null) {
                return "ERROR";
            }
            return data.entityKey();
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distanceToPlayer());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosX());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosY());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosZ());
        }));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> {
            OnStartLookingAtEntityListener.LookedEntityData data = this.lastEntityData;
            if (data == null) {
                return "ERROR";
            }
            return data.uuid().toString();
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_stop_looking_at_entity");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_stop_looking_at_entity.desc", new String[0]));
    }
}

