/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnStartLookingAtBlockListener
extends AbstractListener {
    public static final double MAX_LOOK_DISTANCE = 20.0;
    @Nullable
    private LookedBlockData currentBlockData;

    public OnStartLookingAtBlockListener() {
        super("start_looking_at_block");
    }

    public boolean onLookAtBlock(@NotNull ClientLevel level, @NotNull BlockHitResult hitResult, double distance) {
        LookedBlockData newData = LookedBlockData.from(level, hitResult, distance);
        LookedBlockData existingData = this.currentBlockData;
        if (existingData != null && existingData.isSameTarget(newData)) {
            this.currentBlockData = newData;
            return false;
        }
        this.currentBlockData = newData;
        this.notifyAllInstances();
        return true;
    }

    public void clearCurrentBlock() {
        this.currentBlockData = null;
    }

    @Nullable
    public LookedBlockData getCurrentBlockData() {
        return this.currentBlockData;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null || data.blockKey() == null) {
                return "ERROR";
            }
            return data.blockKey();
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().getX());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().getY());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().getZ());
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distance());
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_start_looking_at_block");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_start_looking_at_block.desc", new String[0]));
    }

    public record LookedBlockData(@NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull ResourceKey<Level> levelKey, @Nullable String blockKey, double distance) {
        private boolean isSameTarget(@NotNull LookedBlockData other) {
            return Objects.equals(this.blockPos, other.blockPos) && Objects.equals(this.blockState, other.blockState) && Objects.equals(this.levelKey, other.levelKey);
        }

        @NotNull
        public static LookedBlockData from(@NotNull ClientLevel level, @NotNull BlockHitResult hitResult, double distance) {
            BlockPos pos = hitResult.getBlockPos().immutable();
            BlockState state = level.getBlockState(pos);
            ResourceKey levelKey = level.dimension();
            ResourceLocation blockKeyLocation = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String blockKey = blockKeyLocation != null ? blockKeyLocation.toString() : null;
            return new LookedBlockData(pos, state, (ResourceKey<Level>)levelKey, blockKey, distance);
        }
    }
}

