/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layer;

import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.customization.widget.identification.WidgetIdentifierHandler;
import de.keksuccino.fancymenu.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ElementFactory {
    default public void constructElementInstances(@Nullable String screenIdentifier, @Nullable List<WidgetMeta> vanillaWidgetMetaList, @NotNull List<Layout> layouts, @NotNull Layout.OrderedElementCollection normalElements, @Nullable List<VanillaWidgetElement> vanillaWidgetElements) {
        HashMap unstackedVanillaButtonElements = new HashMap();
        for (Layout layout : layouts) {
            Layout.OrderedElementCollection layoutElements = layout.buildElementInstances();
            normalElements.backgroundElements.addAll(layoutElements.backgroundElements);
            normalElements.foregroundElements.addAll(layoutElements.foregroundElements);
            if (vanillaWidgetElements == null) continue;
            for (VanillaWidgetElement element : layout.buildVanillaButtonElementInstances()) {
                WidgetMeta d = vanillaWidgetMetaList != null ? ElementFactory.findWidgetMeta(element.getInstanceIdentifier(), vanillaWidgetMetaList) : null;
                if (d == null) continue;
                element.setVanillaWidget(d, element.anchorPoint == ElementAnchorPoints.VANILLA);
                if (!unstackedVanillaButtonElements.containsKey(d)) {
                    unstackedVanillaButtonElements.put(d, new ArrayList());
                }
                ((List)unstackedVanillaButtonElements.get(d)).add(element);
            }
        }
        if (vanillaWidgetMetaList != null && vanillaWidgetElements != null) {
            for (WidgetMeta widgetMeta : vanillaWidgetMetaList) {
                if (unstackedVanillaButtonElements.containsKey(widgetMeta)) continue;
                VanillaWidgetElement element = VanillaWidgetElementBuilder.INSTANCE.buildDefaultInstance();
                element.setVanillaWidget(widgetMeta, true);
                unstackedVanillaButtonElements.put(widgetMeta, new ArrayList());
                ((List)unstackedVanillaButtonElements.get(widgetMeta)).add(element);
            }
            for (Map.Entry entry : unstackedVanillaButtonElements.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                if (((List)entry.getValue()).size() > 1) {
                    VanillaWidgetElement stacked = VanillaWidgetElementBuilder.INSTANCE.stackElementsInternal(VanillaWidgetElementBuilder.INSTANCE.buildDefaultInstance(), ((List)entry.getValue()).toArray(new VanillaWidgetElement[0]));
                    if (stacked == null) continue;
                    if (stacked.anchorPoint == ElementAnchorPoints.VANILLA) {
                        stacked.mirrorVanillaWidgetSizeAndPosition();
                    }
                    vanillaWidgetElements.add(stacked);
                    continue;
                }
                if (((VanillaWidgetElement)((List)entry.getValue()).get((int)0)).anchorPoint == ElementAnchorPoints.VANILLA) {
                    ((VanillaWidgetElement)((List)entry.getValue()).get(0)).mirrorVanillaWidgetSizeAndPosition();
                }
                vanillaWidgetElements.add((VanillaWidgetElement)((List)entry.getValue()).get(0));
            }
        }
    }

    default public void constructElementInstances(@Nullable String menuIdentifier, @Nullable List<WidgetMeta> vanillaWidgetMetaList, @NotNull Layout layout, @NotNull Layout.OrderedElementCollection normalElements, @Nullable List<VanillaWidgetElement> vanillaWidgetElements) {
        this.constructElementInstances(menuIdentifier, vanillaWidgetMetaList, ListUtils.of(layout), normalElements, vanillaWidgetElements);
    }

    @Nullable
    private static WidgetMeta findWidgetMeta(@NotNull String identifier, @NotNull List<WidgetMeta> metas) {
        identifier = identifier.replace("vanillabtn:", "");
        for (WidgetMeta meta : metas) {
            if (!WidgetIdentifierHandler.isIdentifierOfWidget(identifier, meta)) continue;
            return meta;
        }
        return null;
    }
}

