/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.ScrollableMarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HEADER_HEIGHT = 40;
    private static final int FOOTER_HEIGHT = 50;
    private static final int BORDER = 40;
    private final Screen parent;
    private final Component headline = Component.translatable((String)"fancymenu.welcome.screen.headline").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private ScrollableMarkdownRenderer markdownRenderer;
    private final Font font;

    public WelcomeScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"fancymenu.welcome.screen.title"));
        this.font = Minecraft.getInstance().font;
        this.parent = parent;
    }

    protected void init() {
        int centerX = this.width / 2;
        int scrollWidth = this.width - 80;
        int scrollHeight = this.height - 40 - 50;
        if (this.markdownRenderer == null) {
            this.markdownRenderer = new ScrollableMarkdownRenderer(centerX - scrollWidth / 2, 40.0f, scrollWidth, scrollHeight);
        } else {
            this.markdownRenderer.rebuild(centerX - scrollWidth / 2, 40.0f, scrollWidth, scrollHeight);
        }
        this.markdownRenderer.getMarkdownRenderer().setText("^^^\n\n\n" + I18n.get((String)"fancymenu.welcome.screen.text", (Object[])new Object[0]) + "\n^^^");
        this.markdownRenderer.getMarkdownRenderer().setAutoLineBreakingEnabled(true);
        this.addRenderableWidget((GuiEventListener)this.markdownRenderer);
        ((ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(centerX - 100, this.height - 25 - 10, 200, 20, (Component)Component.translatable((String)"fancymenu.welcome.screen.open_docs"), button -> {
            try {
                WebUtils.openWebLink("https://docs.fancymenu.net");
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to open FancyMenu docs in WelcomeScreen!", (Throwable)ex);
            }
            FancyMenu.getOptions().showWelcomeScreen.setValue(false);
            this.onClose();
        }))).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.welcome.screen.open_docs.tooltip", new String[0])));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, this.headline, n, 20 - 9 / 2, -1);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.renderBackground(graphics, mouseX, mouseY, partial);
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor(graphics);
        graphics.fillGradient(0, 40, this.width, 44, -16777216, 0);
        graphics.fillGradient(0, this.height - 50 - 4, this.width, this.height - 50, 0, -16777216);
        RenderingUtils.resetShaderColor(graphics);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.markdownRenderer.mouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.markdownRenderer.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

