/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.mixin.create;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import plus.dragons.createdragonsplus.common.kinetics.fan.AirCurrentAccess;
import plus.dragons.createdragonsplus.common.kinetics.fan.AirCurrentSegmentAccess;
import plus.dragons.createdragonsplus.common.kinetics.fan.DynamicParticleFanProcessingType;
import plus.dragons.createdragonsplus.common.registry.CDPFanProcessingTypes;

@Mixin(value={AirCurrent.class})
public class AirCurrentMixin
implements AirCurrentAccess {
    @Shadow
    public float maxDistance;
    @Shadow
    public List<AirCurrentSegmentAccess> segments;
    @Shadow
    @Final
    public IAirCurrentSource source;
    @Shadow
    public boolean pushing;

    @ModifyExpressionValue(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;getAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;")})
    @Nullable
    private FanProcessingType rebuild$checkDragonHead(@Nullable FanProcessingType original, @Local(name={"world"}) Level world, @Local(name={"currentPos"}) BlockPos currentPos) {
        Direction facing;
        BlockState state = world.getBlockState(currentPos);
        Direction direction = this.source.getAirFlowDirection();
        if (state.is(Blocks.DRAGON_HEAD) ? direction == (facing = RotationSegment.convertToDirection((int)((Integer)state.getValue((Property)SkullBlock.ROTATION))).orElse(direction)) : state.is(Blocks.DRAGON_WALL_HEAD) && state.getValue((Property)WallSkullBlock.FACING) == direction) {
            return (FanProcessingType)CDPFanProcessingTypes.ENDING.get();
        }
        return original;
    }

    @WrapOperation(method={"rebuild"}, at={@At(value="FIELD", opcode=181, target="Lcom/simibubi/create/content/kinetics/fan/AirCurrent$AirCurrentSegment;type:Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;")})
    private void rebuild$setParticleData(@Coerce Object segment, FanProcessingType value, Operation<Void> original, @Local(name={"world"}) Level world, @Local(name={"currentPos"}) BlockPos currentPos) {
        original.call(new Object[]{segment, value});
        AirCurrentSegmentAccess access = (AirCurrentSegmentAccess)segment;
        FanProcessingType fanProcessingType = access.getType();
        if (fanProcessingType instanceof DynamicParticleFanProcessingType) {
            DynamicParticleFanProcessingType type = (DynamicParticleFanProcessingType)fanProcessingType;
            access.setParticleData(type, type.getParticleDataAt(world, currentPos));
        }
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;spawnProcessingParticles(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V")})
    private void tickAffectedEntities$spawnProcessingParticlesWithParticleData(FanProcessingType type, Level level, Vec3 pos, Operation<Void> original, @Local(name={"entityDistance"}) double distance) {
        if (type instanceof DynamicParticleFanProcessingType) {
            DynamicParticleFanProcessingType dynamicType = (DynamicParticleFanProcessingType)type;
            AirCurrentSegmentAccess segment = this.getSegmentAccessAt((float)distance);
            Object particleData = segment == null ? null : (Object)segment.getParticleData(dynamicType);
            dynamicType.spawnProcessingParticles(level, pos, particleData);
        } else {
            original.call(new Object[]{type, level, pos});
        }
    }

    @Override
    @Nullable
    public AirCurrentSegmentAccess getSegmentAccessAt(float offset) {
        block4: {
            if (!(offset >= 0.0f) || !(offset <= this.maxDistance)) break block4;
            if (this.pushing) {
                for (AirCurrentSegmentAccess segment : this.segments) {
                    if (!(offset <= (float)segment.getEndOffset())) continue;
                    return segment;
                }
            } else {
                for (AirCurrentSegmentAccess segment : this.segments) {
                    if (!(offset >= (float)segment.getEndOffset())) continue;
                    return segment;
                }
            }
        }
        return null;
    }

    @Mixin(targets={"com.simibubi.create.content.kinetics.fan.AirCurrent$AirCurrentSegment"})
    public static abstract class AirCurrentSegmentMixin
    implements AirCurrentSegmentAccess {
        @Shadow
        @Nullable
        private FanProcessingType type;
        @Unique
        @Nullable
        private Object particleData;

        @Override
        @Accessor
        @Nullable
        public abstract FanProcessingType getType();

        @Override
        @Accessor
        public abstract int getStartOffset();

        @Override
        @Accessor
        public abstract int getEndOffset();

        @Override
        @Nullable
        public <T> T getParticleData(DynamicParticleFanProcessingType<T> type) {
            if (this.type == type) {
                return (T)this.particleData;
            }
            return null;
        }

        @Override
        public <T> void setParticleData(DynamicParticleFanProcessingType<T> type, @Nullable T particleData) {
            if (this.type == type) {
                this.particleData = particleData;
            }
        }
    }
}

