/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.config;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.infrastructure.config.CStress;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={CStress.class}, source={"create"}, license={"mit"})
public class StressConfig
extends ConfigBase {
    protected final String modid;
    protected final Object2DoubleMap<ResourceLocation> defaultImpacts = new Object2DoubleOpenHashMap();
    protected final Object2DoubleMap<ResourceLocation> defaultCapacities = new Object2DoubleOpenHashMap();
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();

    public StressConfig(String modid) {
        this.modid = modid;
    }

    protected int getVersion() {
        return 1;
    }

    public void registerAll(ModConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.su, Comments.impact}).push("impact");
        this.defaultImpacts.forEach((id, value) -> this.impacts.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
        builder.comment(new String[]{".", Comments.su, Comments.capacity}).push("capacity");
        this.defaultCapacities.forEach((id, value) -> this.capacities.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
        BlockStressValues.IMPACTS.registerProvider(this::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(this::getCapacity);
    }

    public String getName() {
        return "stressValues.v" + this.getVersion();
    }

    @Nullable
    public DoubleSupplier getImpact(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.impacts.get(id);
        return value == null ? null : () -> value.get();
    }

    @Nullable
    public DoubleSupplier getCapacity(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.capacities.get(id);
        return value == null ? null : () -> value.get();
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return this.setImpact(0.0);
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double value) {
        return builder -> {
            this.validateOwningMod((BlockBuilder<?, ?>)builder);
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)builder.getName());
            this.defaultImpacts.put((Object)id, value);
            return builder;
        };
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double value) {
        return builder -> {
            this.validateOwningMod((BlockBuilder<?, ?>)builder);
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)builder.getName());
            this.defaultCapacities.put((Object)id, value);
            return builder;
        };
    }

    private void validateOwningMod(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals(this.modid)) {
            throw new IllegalStateException("Config only accepts blocks from " + this.modid);
        }
    }

    static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        Comments() {
        }
    }
}

