/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.config;

import net.minecraft.Util;
import net.minecraft.util.Unit;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import plus.dragons.createdragonsplus.config.CDPClientConfig;
import plus.dragons.createdragonsplus.config.CDPCommonConfig;
import plus.dragons.createdragonsplus.config.CDPFeaturesConfig;
import plus.dragons.createdragonsplus.config.CDPRecipesConfig;
import plus.dragons.createdragonsplus.config.CDPServerConfig;

public class CDPConfig {
    private static final CDPCommonConfig COMMON_CONFIG = new CDPCommonConfig();
    private static final CDPClientConfig CLIENT_CONFIG = new CDPClientConfig();
    private static final CDPServerConfig SERVER_CONFIG = new CDPServerConfig();
    private static ModConfigSpec COMMON_SPEC;
    private static ModConfigSpec CLIENT_SPEC;
    private static ModConfigSpec SERVER_SPEC;

    public CDPConfig(ModContainer container) {
        COMMON_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            COMMON_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec));
        CLIENT_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            CLIENT_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec));
        SERVER_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            SERVER_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec));
    }

    public static CDPCommonConfig common() {
        return COMMON_CONFIG;
    }

    public static CDPClientConfig client() {
        return CLIENT_CONFIG;
    }

    public static CDPServerConfig server() {
        return SERVER_CONFIG;
    }

    public static CDPFeaturesConfig features() {
        return CDPConfig.COMMON_CONFIG.features;
    }

    public static CDPRecipesConfig recipes() {
        return CDPConfig.SERVER_CONFIG.recipes;
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (spec == COMMON_SPEC) {
            COMMON_CONFIG.onLoad();
        } else if (spec == CLIENT_SPEC) {
            CLIENT_CONFIG.onLoad();
        } else if (spec == SERVER_SPEC) {
            SERVER_CONFIG.onLoad();
        }
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (spec == COMMON_SPEC) {
            COMMON_CONFIG.onReload();
        } else if (spec == CLIENT_SPEC) {
            CLIENT_CONFIG.onReload();
        } else if (spec == SERVER_SPEC) {
            SERVER_CONFIG.onReload();
        }
    }
}

