/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.network.packet;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherBlockEntity;
import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherMenu;
import com.finchy.pipeorgans.network.AllPackets;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;

public record MidiUploadPacket(int code, long size, String midi, byte[] data) implements ServerboundPacketPayload
{
    public static final int BEGIN = 0;
    public static final int WRITE = 1;
    public static final int FINISH = 2;
    public static final StreamCodec<ByteBuf, MidiUploadPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MidiUploadPacket::code, (StreamCodec)ByteBufCodecs.VAR_LONG, MidiUploadPacket::size, (StreamCodec)CatnipStreamCodecBuilders.nullable((StreamCodec)ByteBufCodecs.stringUtf8((int)256)), MidiUploadPacket::midi, (StreamCodec)CatnipStreamCodecBuilders.nullable((StreamCodec)ByteBufCodecs.byteArray((int)Integer.MAX_VALUE)), MidiUploadPacket::data, MidiUploadPacket::new);

    public static MidiUploadPacket begin(String midi, long size) {
        return new MidiUploadPacket(0, size, midi, null);
    }

    public static MidiUploadPacket write(String midi, byte[] data) {
        return new MidiUploadPacket(1, 0L, midi, data);
    }

    public static MidiUploadPacket finish(String midi) {
        return new MidiUploadPacket(2, 0L, midi, null);
    }

    public void handle(ServerPlayer player) {
        if (this.code == 0) {
            BlockPos pos = ((RollPuncherBlockEntity)((Object)((RollPuncherMenu)player.containerMenu).contentHolder)).getBlockPos();
            PipeOrgans.MIDI_RECEIVER.handleNewUpload(player, this.midi, this.size, pos);
        }
        if (this.code == 1) {
            PipeOrgans.MIDI_RECEIVER.handleWriteRequest(player, this.midi, this.data);
        }
        if (this.code == 2) {
            PipeOrgans.MIDI_RECEIVER.handleFinishedUpload(player, this.midi);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.MIDI_UPLOAD;
    }
}

