/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.midi.client;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.network.packet.KBRMidiMessagePacket;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class MidiDeviceInputReceiver
implements Receiver {
    private volatile boolean open = true;

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (this.open) {
            this.handleMessage(message);
        }
    }

    @Override
    public void close() {
        this.open = false;
    }

    protected void handleMessage(MidiMessage message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && PipeOrgans.getProxy().isClient()) {
            this.sendNotePacket(message);
        }
    }

    public void sendNotePacket(MidiMessage message) {
        int code = -1;
        if (message instanceof ShortMessage) {
            code = 0;
        } else if (message instanceof SysexMessage) {
            code = 1;
        }
        byte[] data = message.getMessage();
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new KBRMidiMessagePacket(code, data.length, data));
    }
}

