/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.midi.client;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.MidiFileParser;
import com.finchy.pipeorgans.midi.PipeOrgansPaths;
import com.finchy.pipeorgans.network.packet.MidiUploadPacket;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientMidiLoader {
    private List<Component> availableMidis = new ArrayList<Component>();
    private Map<String, InputStream> activeUploads = new HashMap<String, InputStream>();
    private int packetCycle;
    private static final int PACKET_DELAY = 10;
    private static final String EXTENSION = ".mid";

    public ClientMidiLoader() {
        this.refresh();
    }

    public void tick() {
        if (this.activeUploads.isEmpty()) {
            return;
        }
        if (this.packetCycle-- > 0) {
            return;
        }
        this.packetCycle = 10;
        for (String midi : new HashSet<String>(this.activeUploads.keySet())) {
            this.continueUpload(midi);
        }
    }

    public void startNewUpload(String midi) {
        Path path = PipeOrgansPaths.MIDIS_DIR.resolve(midi);
        if (!Files.exists(path, new LinkOption[0])) {
            PipeOrgans.LOGGER.error("Missing .mid file: {}", (Object)path);
            return;
        }
        try {
            long size = Files.size(path);
            if (!MidiFileParser.validateSizeLimitation(size)) {
                return;
            }
            if (!MidiFileParser.isValidMidi(path.toFile())) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.displayClientMessage((Component)Component.literal((String)".mid file is in the wrong format"), false);
                }
                return;
            }
            InputStream in = Files.newInputStream(path, StandardOpenOption.READ);
            this.activeUploads.put(midi, in);
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)MidiUploadPacket.begin(midi, size));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void continueUpload(String midi) {
        if (this.activeUploads.containsKey(midi)) {
            int maxPacketSize = 1024;
            byte[] data = new byte[maxPacketSize];
            try {
                int status = this.activeUploads.get(midi).read(data);
                if (status != -1) {
                    if (status < maxPacketSize) {
                        data = Arrays.copyOf(data, status);
                    }
                    if (Minecraft.getInstance().level != null) {
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)MidiUploadPacket.write(midi, data));
                    } else {
                        this.activeUploads.remove(midi);
                        return;
                    }
                }
                if (status < maxPacketSize) {
                    this.finishUpload(midi);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void finishUpload(String midi) {
        if (this.activeUploads.containsKey(midi)) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)MidiUploadPacket.finish(midi));
            this.activeUploads.remove(midi);
        }
    }

    public void refresh() {
        FilesHelper.createFolderIfMissing((Path)PipeOrgansPaths.MIDIS_DIR);
        this.availableMidis.clear();
        try (Stream<Path> paths2 = Files.list(PipeOrgansPaths.MIDIS_DIR);){
            paths2.filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(EXTENSION)).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableMidis.add((Component)Component.literal((String)path.getFileName().toString()));
            });
        }
        catch (NoSuchFileException paths2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.availableMidis.sort((aT, bT) -> {
            String a = aT.getString();
            String b = bT.getString();
            if (a.endsWith(EXTENSION)) {
                a = a.substring(0, a.length() - 4);
            }
            if (b.endsWith(EXTENSION)) {
                b = b.substring(0, b.length() - 4);
            }
            int aLen = a.length();
            int bLen = b.length();
            int minSize = Math.min(aLen, bLen);
            boolean asNumeric = false;
            int lastNumericCompare = 0;
            for (int i = 0; i < minSize; ++i) {
                boolean bNumber;
                char aChar = a.charAt(i);
                char bChar = b.charAt(i);
                boolean aNumber = aChar >= '0' && aChar <= '9';
                boolean bl = bNumber = bChar >= '0' && bChar <= '9';
                if (asNumeric) {
                    if (aNumber && bNumber) {
                        if (lastNumericCompare != 0) continue;
                        lastNumericCompare = aChar - bChar;
                        continue;
                    }
                    if (aNumber) {
                        return 1;
                    }
                    if (bNumber) {
                        return -1;
                    }
                    if (lastNumericCompare == 0) {
                        if (aChar != bChar) {
                            return aChar - bChar;
                        }
                        asNumeric = false;
                        continue;
                    }
                    return lastNumericCompare;
                }
                if (aNumber && bNumber) {
                    asNumeric = true;
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aChar == bChar) continue;
                return aChar - bChar;
            }
            if (asNumeric) {
                if (aLen > bLen && a.charAt(bLen) >= '0' && a.charAt(bLen) <= '9') {
                    return 1;
                }
                if (bLen > aLen && b.charAt(aLen) >= '0' && b.charAt(aLen) <= '9') {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    return aLen - bLen;
                }
                return lastNumericCompare;
            }
            return aLen - bLen;
        });
    }

    public List<Component> getAvailableMidis() {
        return this.availableMidis;
    }
}

