/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.data;

import com.finchy.pipeorgans.PipeOrgans;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class AssetLookup {
    public static ModelFile partialStandardModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String ... suffix) {
        String string = "/" + ctx.getName();
        for (String suf : suffix) {
            if (suf.isEmpty()) continue;
            string = string + "_" + suf;
        }
        String location = "block/" + ctx.getName() + string;
        return prov.models().getExistingFile(prov.modLoc(location));
    }

    public static ModelFile partialExtensionModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String ... suffix) {
        if (!ctx.getName().endsWith("_extension")) {
            PipeOrgans.LOGGER.error("Tried to generate extension blockstates on a block that is not an extension or is incorrectly named: {}", (Object)ctx.getName());
            return null;
        }
        String pipeName = ctx.getName().substring(0, ctx.getName().length() - "_extension".length());
        String string = "/extension/" + pipeName;
        for (String suf : suffix) {
            if (suf.isEmpty()) continue;
            string = string + "_" + suf;
        }
        String location = "block/" + pipeName + string;
        return prov.models().getExistingFile(prov.modLoc(location));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> existingItemModel() {
        return (c, p) -> p.getExistingFile(p.modLoc("item/" + c.getName()));
    }

    public static Function<BlockState, ModelFile> forPowered(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? AssetLookup.partialStandardModel(ctx, prov, "powered") : AssetLookup.partialStandardModel(ctx, prov, new String[0]);
    }

    public static Function<BlockState, ModelFile> forBooleanProperty(BooleanProperty property, String suffix, DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return state -> (Boolean)state.getValue((Property)property) != false ? AssetLookup.partialStandardModel(ctx, prov, suffix) : AssetLookup.partialStandardModel(ctx, prov, new String[0]);
    }
}

