/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.SingleExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SinglePipeBlock
extends GenericPipeBlock {
    public SinglePipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, 1);
    }

    @Override
    public void incrementSize(Level pLevel, BlockPos pos, boolean playSound) {
        BlockState base = pLevel.getBlockState(pos);
        if (!base.hasProperty((Property)SIZE)) {
            return;
        }
        EPipeSizes.PipeSize size = (EPipeSizes.PipeSize)((Object)base.getValue((Property)SIZE));
        SoundType soundtype = base.getSoundType();
        BlockPos currentPos = pos.above();
        Direction facing = (Direction)base.getValue((Property)FACING);
        float pVolume = (soundtype.getVolume() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
        SoundEvent hitSound = soundtype.getHitSound();
        for (int i = 1; i <= 12; ++i) {
            BlockState blockState = pLevel.getBlockState(currentPos);
            if (!(blockState.getBlock() instanceof SingleExtensionBlock)) {
                if (!blockState.canBeReplaced()) {
                    return;
                }
                BlockState toSet = (BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).defaultBlockState().setValue((Property)SIZE, (Comparable)((Object)size));
                if (((GenericExtensionBlock)((Object)this.extensionBlock.get())).isDirectional()) {
                    toSet = (BlockState)toSet.setValue((Property)FACING, (Comparable)facing);
                }
                pLevel.setBlock(currentPos, toSet, 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                    pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.above();
        }
    }
}

