/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SingleExtensionBlock
extends GenericExtensionBlock<EExtensionShapes.SingleShape> {
    public static final EnumProperty<EExtensionShapes.SingleShape> SHAPE = EnumProperty.create((String)"shape", EExtensionShapes.SingleShape.class);

    public SingleExtensionBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, SHAPE);
    }

    @Override
    protected void registerDefaultStateWithSize() {
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)EExtensionShapes.SingleShape.SINGLE))).setValue((Property)SIZE, (Comparable)((Object)EPipeSizes.PipeSize.MEDIUM));
        if (this.isDirectional()) {
            blockState.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        this.registerDefaultState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{SHAPE, SIZE});
        if (this.isDirectional()) {
            pBuilder.add(new Property[]{FACING});
        }
        super.createBlockStateDefinition(pBuilder);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.getBlockState(pPos.below());
        return below.is((Block)this) && below.getValue(SHAPE) == EExtensionShapes.SingleShape.SINGLE_CONNECTED || below.getBlock() == this.baseBlock.get();
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.getAxis() != Direction.Axis.Y) {
            return pState;
        }
        if (pDirection == Direction.UP) {
            boolean connected = pState.getValue(SHAPE) == EExtensionShapes.SingleShape.SINGLE_CONNECTED;
            boolean shouldConnect = pLevel.getBlockState(pPos.above()).is((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)EExtensionShapes.SingleShape.SINGLE_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)EExtensionShapes.SingleShape.SINGLE));
            }
            return pState;
        }
        return !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : (BlockState)pState.setValue((Property)SIZE, (Comparable)((Object)((EPipeSizes.PipeSize)((Object)pLevel.getBlockState(pPos.below()).getValue((Property)SIZE)))));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        return this.callSuperOnSneakWrenched(state, context);
    }
}

