/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.QuadrupleExtensionBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class QuadruplePipeBlockEntity
extends GenericPipeBlockEntity {
    public QuadruplePipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void updatePitch() {
        BlockState blockState;
        int newPitch;
        BlockPos currentPos = this.worldPosition.above();
        for (newPitch = 0; newPitch <= 12 && (blockState = this.level.getBlockState(currentPos)).getBlock() instanceof QuadrupleExtensionBlock; newPitch += 4) {
            if (blockState.getValue(QuadrupleExtensionBlock.SHAPE) == EExtensionShapes.QuadrupleShape.SINGLE) {
                ++newPitch;
                break;
            }
            if (blockState.getValue(QuadrupleExtensionBlock.SHAPE) == EExtensionShapes.QuadrupleShape.DOUBLE) {
                newPitch += 2;
                break;
            }
            if (blockState.getValue(QuadrupleExtensionBlock.SHAPE) == EExtensionShapes.QuadrupleShape.TRIPLE) {
                newPitch += 3;
                break;
            }
            currentPos = currentPos.above();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }
}

