/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DoubleExtensionBlock
extends GenericExtensionBlock<EExtensionShapes.DoubleShape> {
    public static final EnumProperty<EExtensionShapes.DoubleShape> SHAPE = EnumProperty.create((String)"shape", EExtensionShapes.DoubleShape.class);

    public DoubleExtensionBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, SHAPE);
    }

    @Override
    protected void registerDefaultStateWithSize() {
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)EExtensionShapes.DoubleShape.SINGLE))).setValue((Property)SIZE, (Comparable)((Object)EPipeSizes.PipeSize.MEDIUM));
        if (this.isDirectional()) {
            blockState.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        this.registerDefaultState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{SHAPE, SIZE});
        if (this.isDirectional()) {
            pBuilder.add(new Property[]{FACING});
        }
        super.createBlockStateDefinition(pBuilder);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.getBlockState(pPos.below());
        return below.is((Block)this) && below.getValue(SHAPE) == EExtensionShapes.DoubleShape.DOUBLE_CONNECTED || below.getBlock() == this.baseBlock.get();
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.getAxis() != Direction.Axis.Y) {
            return pState;
        }
        if (pDirection == Direction.UP) {
            boolean connected = pState.getValue(SHAPE) == EExtensionShapes.DoubleShape.DOUBLE_CONNECTED;
            boolean shouldConnect = pLevel.getBlockState(pPos.above()).is((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)EExtensionShapes.DoubleShape.DOUBLE_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)EExtensionShapes.DoubleShape.DOUBLE));
            }
            return pState;
        }
        return !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : (BlockState)pState.setValue((Property)SIZE, (Comparable)((Object)((EPipeSizes.PipeSize)((Object)pLevel.getBlockState(pPos.below()).getValue((Property)SIZE)))));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (context.getClickLocation().y < (double)((float)context.getClickedPos().getY() + 0.5f) || state.getValue(SHAPE) == EExtensionShapes.DoubleShape.SINGLE) {
            return this.callSuperOnSneakWrenched(state, context);
        }
        world.setBlock(pos, (BlockState)state.setValue(SHAPE, (Comparable)((Object)EExtensionShapes.DoubleShape.SINGLE)), 3);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }
}

