/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic;

import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class GenericSoundInstance
extends AbstractTickableSoundInstance {
    private boolean active;
    private int keepAlive;
    private EPipeSizes.PipeSize size;

    public GenericSoundInstance(EPipeSizes.PipeSize size, BlockPos worldPosition, SoundEvent soundEvent) {
        super(soundEvent, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.size = size;
        this.looping = true;
        this.active = true;
        this.volume = 0.05f;
        this.delay = 0;
        this.keepAlive();
        Vec3 v = Vec3.atCenterOf((Vec3i)worldPosition);
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public EPipeSizes.PipeSize getOctave() {
        return this.size;
    }

    public void fadeOut() {
        this.active = false;
    }

    public void keepAlive() {
        this.keepAlive = 2;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void tick() {
        if (this.active) {
            this.volume = Math.min(1.0f, this.volume + 0.25f);
            --this.keepAlive;
            if (this.keepAlive == 0) {
                this.fadeOut();
            }
            return;
        }
        this.volume = Math.max(0.0f, this.volume - 0.25f);
        if (this.volume == 0.0f) {
            this.stop();
        }
    }
}

