/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic;

import com.finchy.pipeorgans.ClientConfig;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockItem;
import com.finchy.pipeorgans.content.windchest.WindchestBlock;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class GenericPipeBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public LerpedFloat animation = LerpedFloat.angular();
    public int pitch;
    protected float steamJetOffset = 0.125f;
    protected BlockEntry<? extends GenericPipeBlock> baseBlock;

    public GenericPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putInt("Pitch", this.pitch);
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.pitch = tag.getInt("Pitch");
        super.read(tag, registries, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = CreateLang.translateDirect((String)"generic.notes", (Object[])new Object[0]).getString().split(";");
        int stopSize = Integer.parseInt(((GenericPipeBlockItem)this.getBlockState().getBlock().asItem()).stopSize);
        double octave = (double)(5 - this.getOctave().ordinal() + (this.pitch <= 6 ? 1 : 0)) - Math.log((double)stopSize / 8.0) / Math.log(2.0);
        boolean useBrackets = ClientConfig.showOctaveBrackets;
        String octaveText = useBrackets || (int)octave == -1 ? "(" + (int)Math.round(octave) + ")" : String.valueOf((int)Math.round(octave));
        CreateLang.translate((String)"generic.pitch", (Object[])new Object[]{pitches[this.pitch % pitches.length]}).add(Component.literal((String)octaveText)).forGoggles(tooltip);
        return true;
    }

    protected boolean isPowered() {
        return this.getBlockState().getOptionalValue((Property)GenericPipeBlock.POWERED).orElse(false);
    }

    protected EPipeSizes.PipeSize getOctave() {
        return this.getBlockState().getOptionalValue(GenericPipeBlock.SIZE).orElse(EPipeSizes.PipeSize.MEDIUM);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            return;
        }
        FluidTankBlockEntity tank = this.getTank();
        BlockState state = this.getBlockState();
        BlockPos attachedPos = this.getBlockPos().relative(GenericPipeBlock.getAttachedDirection(state));
        BlockState attachedState = this.level.getBlockState(attachedPos);
        boolean isActive = false;
        Block block = attachedState.getBlock();
        if (block instanceof WindchestBlock) {
            WindchestBlock windchest = (WindchestBlock)block;
            isActive = windchest.isMasterActive(this.level, (Direction)attachedState.getValue((Property)GenericPipeBlock.FACING), attachedPos);
        }
        boolean powered = this.isPowered() ? tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual() || isActive : false;
        this.animation.chase(powered ? 1.0 : 0.0, powered ? 0.5 : (double)0.4f, powered ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.tickAudio(this.getOctave(), powered));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void tickAudio(EPipeSizes.PipeSize var1, boolean var2);

    public void createSteamJet(EPipeSizes.PipeSize size) {
        Direction facing = this.getBlockState().getOptionalValue((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        Vec3 sizeOffset = VecHelper.rotate((Vec3)new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 0.75), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 v = offset.scale((double)0.45f).add(sizeOffset).add(Vec3.atCenterOf((Vec3i)this.worldPosition));
        Vec3 m = offset.subtract(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.75));
        this.level.addParticle((ParticleOptions)new SteamJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }

    public void createReedSteamJet() {
        double yPos = (double)this.pitch / (double)((GenericPipeBlock)((Object)this.baseBlock.get())).EPB + 1.0 + (double)this.steamJetOffset;
        Vec3 v = new Vec3(0.0, yPos, 0.0).add(Vec3.atBottomCenterOf((Vec3i)this.worldPosition));
        Vec3 m = new Vec3(0.0, 1.0, 0.0);
        this.level.addParticle((ParticleOptions)new SteamJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }

    public abstract void updatePitch();

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.isRemoved()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.level.getBlockEntity(this.worldPosition.relative(facing = GenericPipeBlock.getAttachedDirection(this.getBlockState())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

