/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarMenu;
import com.finchy.pipeorgans.init.AllBlocks;
import com.finchy.pipeorgans.network.packet.TrackerBarGUIPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.ArrayList;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class TrackerBarScreen
extends AbstractSimiContainerScreen<TrackerBarMenu> {
    private static final ResourceLocation GUI_TEXTURE = PipeOrgans.asResource("textures/gui/tracker_bar.png");
    private static final int GUI_WIDTH = 330;
    private static final int GUI_HEIGHT = 159;
    protected IconButton playButton;
    protected IconButton stopButton;
    protected IconButton confirmButton;
    private static final int BUTTONS_Y = 135;
    private static final int PLAY_X = 153;
    private static final int STOP_X = 175;
    private static final int CONFIRM_X = 297;
    private static final int MAX_INSTRUMENT_LABEL_WIDTH = 63;
    private static final int INSTRUMENT_LABELS_TEXT_X = 38;
    private static final int INSTRUMENT_LABELS_TEXT_Y = 25;
    private static final int INSTRUMENT_LABELS_HOVER_X = 35;
    private static final int INSTRUMENT_LABELS_HOVER_Y = 23;
    private static final int INSTRUMENT_LABEL_WIDTH = 69;
    private static final int INSTRUMENT_LABEL_HEIGHT = 12;
    private final ItemStack renderedItem = AllBlocks.TRACKER_BAR.asStack();

    public TrackerBarScreen(TrackerBarMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void init() {
        this.setWindowSize(330, 163 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 8);
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        boolean buttonsActive = ((TrackerBarBlockEntity)((Object)((TrackerBarMenu)this.menu).contentHolder)).getButtonsEnabled();
        this.playButton = new IconButton(x + 153, y + 135, (ScreenElement)AllIcons.I_PLAY);
        this.playButton.active = buttonsActive;
        this.playButton.withCallback(() -> this.sendUpdatePacket("play"));
        this.stopButton = new IconButton(x + 175, y + 135, (ScreenElement)AllIcons.I_STOP);
        this.stopButton.active = buttonsActive;
        this.stopButton.withCallback(() -> this.sendUpdatePacket("stop"));
        this.confirmButton = new IconButton(x + 297, y + 135, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((TrackerBarMenu)this.menu).player.closeContainer());
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.playButton, this.stopButton, this.confirmButton});
    }

    private void sendUpdatePacket(String button) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TrackerBarGUIPacket(button, ((TrackerBarBlockEntity)((Object)((TrackerBarMenu)this.menu).contentHolder)).getBlockPos()));
    }

    private static Component shortenText(Component componentIn, int maxWidth) {
        int rawLength;
        Font font = Minecraft.getInstance().font;
        if (font.width((FormattedText)componentIn) <= maxWidth) {
            return componentIn;
        }
        String trim = "...";
        int trimWidth = font.width(trim);
        String raw = componentIn.getString();
        for (int i = rawLength = raw.length(); i > 0; --i) {
            String sub = raw.substring(0, i);
            if (font.width(sub) + trimWidth > maxWidth) continue;
            return Component.literal((String)(sub + trim)).setStyle(componentIn.getStyle());
        }
        return Component.literal((String)trim).setStyle(componentIn.getStyle());
    }

    protected void containerTick() {
        boolean buttonsActive;
        super.containerTick();
        this.playButton.active = buttonsActive = ((TrackerBarMenu)this.menu).getButtonsEnabled();
        this.stopButton.active = buttonsActive;
        this.playButton.setIcon((ScreenElement)(((TrackerBarMenu)this.menu).isPlaying() ? AllIcons.I_PAUSE : AllIcons.I_PLAY));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, (314 - this.font.width((FormattedText)this.title)) / 2, 4, 0x505050, false);
        int channel = 0;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Component instrumentName = ((TrackerBarMenu)this.menu).getChannelInstrumentName(channel++);
                graphics.drawString(this.font, TrackerBarScreen.shortenText((Component)Component.literal((String)(channel + ": ")).append(instrumentName), 63), column * 69 + 38, row * 12 + 25, 0xFFFFFF, true);
            }
        }
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        int labelsHoverX = 35 + this.leftPos;
        int labelsHoverY = 23 + this.topPos;
        if (labelsHoverX + 1 <= mouseX && mouseX <= labelsHoverX + 276 - 1 && labelsHoverY + 1 <= mouseY && mouseY <= labelsHoverY + 48 - 1) {
            int hoveredIndexX = (mouseX - labelsHoverX) / 69;
            int hoveredIndexY = (mouseY - labelsHoverY) / 12;
            Component hoveredName = ((TrackerBarMenu)this.menu).getChannelInstrumentName(hoveredIndexX + 4 * hoveredIndexY);
            if (hoveredName.equals((Object)Component.empty())) {
                return;
            }
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(hoveredName);
            graphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth()) - 15;
        int invY = this.topPos + 159 + 4;
        this.renderPlayerInventory(pGuiGraphics, invX, invY);
        pGuiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(this.leftPos + 330), (float)(this.topPos + 159 - 40), -200.0f)).scale(3.0).render(pGuiGraphics);
    }
}

