/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.init.AllPartialModels;
import com.finchy.pipeorgans.init.AllSpriteShifts;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TrackerBarRenderer
extends KineticBlockEntityRenderer<TrackerBarBlockEntity> {
    public TrackerBarRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(TrackerBarBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level = be.getLevel();
        if (VisualizationManager.supportsVisualization((LevelAccessor)level)) {
            return;
        }
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction shaft = facing.getClockWise();
        TrackerBarRenderer.standardKineticRotationTransform((SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.TRACKER_BAR_SHAFT, (BlockState)state, (Direction)shaft), (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
        float angle = be.getRollerAngle(partialTicks);
        SuperByteBuffer roller1 = CachedBuffers.partial((PartialModel)AllPartialModels.TRACKER_BAR_ROLLER, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)roller1.translate(0.0, 0.28125, 0.0)).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)shaft.getStepX(), (float)shaft.getStepY(), (float)shaft.getStepZ()))).rotateY(angle)).uncenter()).light(light).renderInto(ms, vb);
        SuperByteBuffer roller2 = CachedBuffers.partial((PartialModel)AllPartialModels.TRACKER_BAR_ROLLER, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)roller2.translate((double)((float)facing.getStepX() / 16.0f), -0.34375, (double)((float)facing.getStepZ() / 16.0f))).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)shaft.getStepX(), (float)shaft.getStepY(), (float)shaft.getStepZ()))).rotateY(angle)).uncenter()).light(light).renderInto(ms, vb);
        if (!be.midiSequencerBehaviour.isSequenceLoaded()) {
            return;
        }
        SpriteShiftEntry spriteShift = AllSpriteShifts.SCROLLING_MUSIC;
        float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
        float speed = be.getScrollSpeed();
        double vScroll = speed * AnimationTickHolder.getRenderTime((LevelAccessor)level);
        vScroll -= Math.floor(vScroll);
        SuperByteBuffer paperBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.TRACKER_BAR_PAPER, (BlockState)state);
        paperBuffer.shiftUVScrolling(spriteShift, 0.0f, (float)(vScroll *= (double)(spriteHeight / 2.0f)));
        Direction paperFacing = facing;
        if (paperFacing.equals((Object)Direction.NORTH) || paperFacing.equals((Object)Direction.SOUTH)) {
            paperFacing = paperFacing.getOpposite();
        }
        ((SuperByteBuffer)paperBuffer.rotateCentered(paperFacing.toYRot() * ((float)Math.PI / 180), Axis.YP)).light(light).renderInto(ms, vb);
    }
}

