/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.content.midi.MidiSourceBehaviour;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarSlot;
import com.finchy.pipeorgans.init.AllMenuTypes;
import com.finchy.pipeorgans.util.MidiUtils;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TrackerBarMenu
extends MenuBase<TrackerBarBlockEntity> {
    private final ContainerData data;
    public ItemStackHandler ghostInventory;

    public TrackerBarMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
        this.data = new SimpleContainerData(21);
        this.addDataSlots(this.data);
    }

    public TrackerBarMenu(MenuType<?> type, int id, Inventory inv, TrackerBarBlockEntity be, ContainerData data) {
        super(type, id, inv, (Object)be);
        this.data = data;
        this.addDataSlots(data);
    }

    public static TrackerBarMenu create(int id, Inventory inv, TrackerBarBlockEntity be, ContainerData data) {
        return new TrackerBarMenu((MenuType)AllMenuTypes.TRACKER_BAR_MENU.get(), id, inv, be, data);
    }

    protected TrackerBarBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof TrackerBarBlockEntity) {
            TrackerBarBlockEntity trackerBar = (TrackerBarBlockEntity)blockEntity;
            trackerBar.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return trackerBar;
        }
        return null;
    }

    protected void initAndReadInventory(TrackerBarBlockEntity contentHolder) {
        this.ghostInventory = ((MidiSourceBehaviour)contentHolder.getBehaviour(MidiSourceBehaviour.TYPE)).storedGhostInv;
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container == this.playerInventory;
    }

    protected void addSlots() {
        this.addPlayerSlots(81, 181);
        this.addSlot((Slot)new TrackerBarSlot((IItemHandler)((TrackerBarBlockEntity)((Object)this.contentHolder)).inventory, 0, 12, 39, stack -> ((TrackerBarBlockEntity)((Object)((Object)this.contentHolder))).onRollChanged()));
        int slot = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 8; ++column) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, slot++, column * 39 + 26, row * 20 + 89));
            }
        }
    }

    protected void saveData(TrackerBarBlockEntity contentHolder) {
        ((MidiSourceBehaviour)contentHolder.getBehaviour(MidiSourceBehaviour.TYPE)).storedGhostInv = this.ghostInventory;
    }

    public Component getChannelInstrumentName(int channel) {
        if (channel != 9) {
            MidiUtils.GeneralMidiInstrument instrument = MidiUtils.GeneralMidiInstrument.fromProgram(this.data.get(channel));
            if (instrument != MidiUtils.GeneralMidiInstrument.EMPTY) {
                return Component.translatable((String)instrument.key);
            }
        } else {
            MidiUtils.GeneralMidiDrumkit drumkit = MidiUtils.GeneralMidiDrumkit.fromProgram(this.data.get(channel));
            if (drumkit != MidiUtils.GeneralMidiDrumkit.EMPTY) {
                return Component.translatable((String)drumkit.key);
            }
        }
        return Component.empty();
    }

    public boolean isPlaying() {
        return this.data.get(16) == 1;
    }

    public int getTickPosition() {
        return this.data.get(17);
    }

    public int getEndTick() {
        return this.data.get(18);
    }

    public float getBPM() {
        return (float)this.data.get(19) / 10.0f;
    }

    public boolean getButtonsEnabled() {
        return this.data.get(20) == 1;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack insert;
        if (slotId <= 36) {
            super.clicked(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.getCarried();
        int slot = slotId - 37;
        if (clickTypeIn == ClickType.CLONE) {
            if (player.isCreative() && held.isEmpty()) {
                ItemStack stackInSlot = this.ghostInventory.getStackInSlot(slot).copy();
                stackInSlot.setCount(stackInSlot.getMaxStackSize());
                this.setCarried(stackInSlot);
                return;
            }
            return;
        }
        if (held.isEmpty()) {
            insert = ItemStack.EMPTY;
        } else {
            insert = held.copy();
            insert.setCount(1);
        }
        this.ghostInventory.setStackInSlot(slot, insert);
        this.getSlot(slotId).setChanged();
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (pIndex < 36) {
                if (!this.moveItemStackTo(originalStack, 36, 37, false)) {
                    for (int i = 0; i < this.ghostInventory.getSlots(); ++i) {
                        ItemStack stack = this.ghostInventory.getStackInSlot(i);
                        if (!stack.isEmpty()) continue;
                        ItemStack copy = originalStack.copy();
                        copy.setCount(1);
                        this.ghostInventory.insertItem(i, copy, false);
                        this.getSlot(i + 36).setChanged();
                        break;
                    }
                    return ItemStack.EMPTY;
                }
                ((TrackerBarBlockEntity)((Object)this.contentHolder)).onRollChanged();
            } else if (pIndex == 36) {
                if (!this.moveItemStackTo(originalStack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
                ((TrackerBarBlockEntity)((Object)this.contentHolder)).onRollChanged();
            } else {
                this.ghostInventory.extractItem(pIndex - 37, 1, false);
                this.getSlot(pIndex).setChanged();
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }
}

