/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi;

import com.finchy.pipeorgans.util.MidiLoadException;
import com.finchy.pipeorgans.util.MidiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public abstract class MidiFileParser {
    public static Sequence getSequenceFromFile(String midi, String owner) throws MidiLoadException {
        Path path = Paths.get("midi_files/uploaded", owner, midi);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MidiLoadException("MIDI file does not exist: " + String.valueOf(path));
        }
        try {
            long size = Files.size(path);
            if (!MidiFileParser.validateSizeLimitation(size)) {
                throw new MidiLoadException("MIDI file is too large: " + size + " bytes");
            }
        }
        catch (IOException e) {
            throw new MidiLoadException("Failed to check file size for: " + String.valueOf(path), e);
        }
        if (!MidiFileParser.isValidMidi(path.toFile())) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)".mid file is in the wrong format"), false);
            }
            throw new MidiLoadException("MIDI file is in the wrong format: " + String.valueOf(path));
        }
        try {
            InputStream in = Files.newInputStream(path, StandardOpenOption.READ);
            return MidiSystem.getSequence(in);
        }
        catch (InvalidMidiDataException e) {
            throw new MidiLoadException("MIDI System was unable to get sequence from file: " + String.valueOf(path), e);
        }
        catch (IOException e) {
            throw new MidiLoadException("IO error while reading MIDI file: " + String.valueOf(path), e);
        }
    }

    public static List<Queue<MidiEvent>> parseMidiEvents(Sequence sequence) {
        ArrayList<Queue<MidiEvent>> trackList = new ArrayList<Queue<MidiEvent>>();
        for (Track track : sequence.getTracks()) {
            LinkedList<MidiEvent> eventQueue = new LinkedList<MidiEvent>();
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                eventQueue.add(event);
            }
            trackList.add(eventQueue);
        }
        return trackList;
    }

    public static void initialParse(Sequence sequence, BiConsumer<Integer, Integer> channelInstrumentConsumer, Consumer<byte[]> tempoConsumer) {
        Track[] tracks;
        for (Track track : tracks = sequence.getTracks()) {
            MidiEvent event;
            for (int i = 0; i < track.size() && (event = track.get(i)).getTick() <= 0L; ++i) {
                MetaMessage mm;
                ShortMessage sm;
                MidiMessage msg = event.getMessage();
                if (msg instanceof ShortMessage && MidiUtils.isProgramChange(sm = (ShortMessage)msg)) {
                    channelInstrumentConsumer.accept(sm.getChannel(), sm.getData1());
                    continue;
                }
                if (!(msg instanceof MetaMessage) || !MidiUtils.isTempoChange(mm = (MetaMessage)msg)) continue;
                tempoConsumer.accept(mm.getData());
            }
        }
    }

    public static int endTick(Sequence sequence) {
        Track[] tracks = sequence.getTracks();
        long songEndTick = 1L;
        for (Track track : tracks) {
            long trackEndTick = 1L;
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                trackEndTick = Math.max(trackEndTick, event.getTick());
            }
            songEndTick = Math.max(songEndTick, trackEndTick);
        }
        return (int)songEndTick;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidMidi(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[4];
            if (fis.read(bytes) != 4) {
                boolean bl = false;
                return bl;
            }
            int byte1 = bytes[0] & 0xFF;
            int byte2 = bytes[1] & 0xFF;
            int byte3 = bytes[2] & 0xFF;
            int byte4 = bytes[3] & 0xFF;
            boolean bl = byte1 == 77 && byte2 == 84 && byte3 == 104 && byte4 == 100;
            return bl;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static boolean validateSizeLimitation(long size) {
        return true;
    }
}

