/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans;

import com.finchy.pipeorgans.ClientConfig;
import com.finchy.pipeorgans.ServerConfig;
import com.finchy.pipeorgans.data.PipeOrgansDatagen;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllBlocks;
import com.finchy.pipeorgans.init.AllCreativeModeTabs;
import com.finchy.pipeorgans.init.AllDataComponents;
import com.finchy.pipeorgans.init.AllDisplaySources;
import com.finchy.pipeorgans.init.AllItems;
import com.finchy.pipeorgans.init.AllMenuTypes;
import com.finchy.pipeorgans.init.AllParticleTypes;
import com.finchy.pipeorgans.init.AllSoundEvents;
import com.finchy.pipeorgans.init.AllSpriteShifts;
import com.finchy.pipeorgans.midi.Proxy;
import com.finchy.pipeorgans.midi.client.ClientProxy;
import com.finchy.pipeorgans.midi.server.ServerMidiLoader;
import com.finchy.pipeorgans.midi.server.ServerProxy;
import com.finchy.pipeorgans.network.AllPackets;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="pipeorgans")
public class PipeOrgans {
    public static final String MOD_ID = "pipeorgans";
    public static final Logger LOGGER;
    private static final CreateRegistrate REGISTRATE;
    public static final ServerMidiLoader MIDI_RECEIVER;
    protected static Proxy proxy;

    public static Proxy getProxy() {
        return proxy;
    }

    public static void setProxy(Proxy inProxy) {
        proxy = inProxy;
    }

    public PipeOrgans(IEventBus modEventBus, ModContainer container) {
        REGISTRATE.registerEventListeners(modEventBus);
        AllCreativeModeTabs.register(modEventBus);
        AllBlocks.register();
        AllBlockEntities.register();
        AllDisplaySources.register();
        AllItems.register();
        AllSoundEvents.register(modEventBus);
        AllSpriteShifts.register();
        AllParticleTypes.register(modEventBus);
        AllMenuTypes.register();
        AllPackets.register();
        AllDataComponents.register(modEventBus);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        modEventBus.addListener(EventPriority.HIGHEST, PipeOrgansDatagen::gatherDataHighPriority);
        modEventBus.addListener(EventPriority.LOWEST, PipeOrgansDatagen::gatherData);
        proxy.init();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    static {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            PipeOrgans.setProxy(new ClientProxy());
        } else {
            PipeOrgans.setProxy(new ServerProxy());
        }
        LOGGER = LogUtils.getLogger();
        REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)MOD_ID).defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        MIDI_RECEIVER = new ServerMidiLoader();
    }
}

