/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum InventoryOrder implements StringRepresentable
{
    MAIN_FIRST("main_first"),
    INCEPTED_FIRST("incepted_first");

    public static final Codec<InventoryOrder> CODEC;
    public static final StreamCodec<FriendlyByteBuf, InventoryOrder> STREAM_CODEC;
    private final String name;
    private static final Map<String, InventoryOrder> NAME_VALUES;
    private static final InventoryOrder[] VALUES;

    private InventoryOrder(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public InventoryOrder next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static InventoryOrder fromName(String name) {
        return NAME_VALUES.getOrDefault(name, MAIN_FIRST);
    }

    static {
        CODEC = StringRepresentable.fromEnum(InventoryOrder::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(InventoryOrder.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (InventoryOrder value : InventoryOrder.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = InventoryOrder.values();
    }
}

