/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.C2SPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CameraMovePacketOld
implements C2SPacket {
    final int id;
    final float yRot;
    final float xRot;

    public CameraMovePacketOld(ConductorEntity entity, float yRot, float xRot) {
        this.id = entity.getId();
        this.yRot = yRot;
        this.xRot = xRot;
    }

    public CameraMovePacketOld(FriendlyByteBuf buf) {
        this.id = buf.readVarInt();
        this.yRot = buf.readFloat();
        this.xRot = buf.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.id);
        buffer.writeFloat(this.yRot);
        buffer.writeFloat(this.xRot);
    }

    @Override
    public void handle(ServerPlayer sender) {
        Entity entity = sender.level().getEntity(this.id);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            if (sender.getCamera() == conductor) {
                conductor.setYRot(this.yRot % 360.0f);
                conductor.setXRot(Mth.clamp((float)this.xRot, (float)-90.0f, (float)90.0f) % 360.0f);
            }
        }
    }
}

