/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.google.common.primitives.Floats;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CameraMovePacket
implements C2SPacket,
S2CPacket {
    final int id;
    final MoveData move;

    public CameraMovePacket(ConductorEntity entity, ServerboundMovePlayerPacket.PosRot packet) {
        this.id = entity.getId();
        this.move = new MoveData(packet.getX(entity.getX()), packet.getY(entity.getY()), packet.getZ(entity.getZ()), packet.getYRot(entity.getYRot()), packet.getXRot(entity.getXRot()), packet.isOnGround());
    }

    public CameraMovePacket(FriendlyByteBuf buf) {
        this.id = buf.readVarInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float yaw = buf.readFloat();
        float pitch = buf.readFloat();
        boolean onGround = buf.readBoolean();
        this.move = new MoveData(x, y, z, yaw, pitch, onGround);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.id);
        buffer.writeDouble(this.move.x);
        buffer.writeDouble(this.move.y);
        buffer.writeDouble(this.move.z);
        buffer.writeFloat(this.move.yaw);
        buffer.writeFloat(this.move.pitch);
        buffer.writeBoolean(this.move.onGround);
    }

    @Override
    public void handle(Minecraft mc) {
        ConductorEntity conductor;
        Entity entity;
        if (mc.level != null && (entity = mc.level.getEntity(this.id)) instanceof ConductorEntity && mc.cameraEntity == (conductor = (ConductorEntity)entity)) {
            double d0 = this.move.getX(conductor.getX());
            double d1 = this.move.getY(conductor.getY());
            double d2 = this.move.getZ(conductor.getZ());
            conductor.syncPacketPositionCodec(d0, d1, d2);
            conductor.setPos(d0, d1, d2);
            float f = this.move.getYRot(conductor.getYRot());
            float f1 = this.move.getXRot(conductor.getXRot());
            conductor.lerpTo(d0, d1, d2, f, f1, 3);
            conductor.setOnGround(this.move.isOnGround());
        }
    }

    private static boolean containsInvalidValues(double x, double y, double z, float yaw, float pitch) {
        return Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double clampHorizontal(double value) {
        return Mth.clamp((double)value, (double)-3.0E7, (double)3.0E7);
    }

    private static double clampVertical(double value) {
        return Mth.clamp((double)value, (double)-2.0E7, (double)2.0E7);
    }

    private static boolean isPlayerCollidingWithAnythingNew(ConductorEntity conductor, LevelReader world, AABB box) {
        Iterable iterable = world.getCollisions((Entity)conductor, conductor.getBoundingBox().deflate((double)1.0E-5f));
        VoxelShape voxelShape = Shapes.create((AABB)box.deflate((double)1.0E-5f));
        for (VoxelShape voxelShape2 : iterable) {
            if (Shapes.joinIsNotEmpty((VoxelShape)voxelShape2, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.AND)) continue;
            return true;
        }
        return false;
    }

    public static void teleport(ServerPlayer player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch) {
        CameraMovePacket.teleport(player, conductor, x, y, z, yaw, pitch, Collections.emptySet(), false);
    }

    public static void teleport(ServerPlayer player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch, Set<RelativeMovement> relativeSet, boolean dismountVehicle) {
        double d = relativeSet.contains(RelativeMovement.X) ? conductor.getX() : 0.0;
        double e = relativeSet.contains(RelativeMovement.Y) ? conductor.getY() : 0.0;
        double f = relativeSet.contains(RelativeMovement.Z) ? conductor.getZ() : 0.0;
        float g = relativeSet.contains(RelativeMovement.Y_ROT) ? conductor.getYRot() : 0.0f;
        float h = relativeSet.contains(RelativeMovement.X_ROT) ? conductor.getXRot() : 0.0f;
        conductor.absMoveTo(x, y, z, yaw, pitch);
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(conductor, new ServerboundMovePlayerPacket.PosRot(x, y, z, yaw, pitch, conductor.onGround())));
    }

    @Override
    public void handle(ServerPlayer sender1) {
        Entity entity = sender1.level().getEntity(this.id);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            if (sender1.getCamera() == conductor) {
                boolean bl2;
                if (CameraMovePacket.containsInvalidValues(this.move.getX(0.0), this.move.getY(0.0), this.move.getZ(0.0), this.move.getYRot(0.0f), this.move.getXRot(0.0f))) {
                    sender1.connection.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.invalid_player_movement"));
                    return;
                }
                Level level = conductor.level();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                double d = CameraMovePacket.clampHorizontal(this.move.getX(conductor.getX()));
                double e = CameraMovePacket.clampVertical(this.move.getY(conductor.getY()));
                double f = CameraMovePacket.clampHorizontal(this.move.getZ(conductor.getZ()));
                float g = Mth.wrapDegrees((float)this.move.getYRot(conductor.getYRot()));
                float h = Mth.wrapDegrees((float)this.move.getXRot(conductor.getXRot()));
                if (conductor.isPassenger()) {
                    conductor.absMoveTo(conductor.getX(), conductor.getY(), conductor.getZ(), g, h);
                    return;
                }
                double i = conductor.getX();
                double j = conductor.getY();
                double k = conductor.getZ();
                double l = conductor.getY();
                double m = d - conductor.firstGoodX;
                double n = e - conductor.firstGoodY;
                double o = f - conductor.firstGoodZ;
                double p = conductor.getDeltaMovement().lengthSqr();
                double q = m * m + n * n + o * o;
                ++conductor.receivedMovePacketCount;
                int r = conductor.receivedMovePacketCount - conductor.knownMovePacketCount;
                if (r > 5) {
                    Railways.LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)sender1.getName().getString(), (Object)r);
                    r = 1;
                }
                float s = conductor.isFallFlying() ? 300.0f : 100.0f;
                float f2 = s;
                if (q - p > (double)(s * (float)r)) {
                    Railways.LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{sender1.getName().getString(), m, n, o});
                    CameraMovePacket.teleport(sender1, conductor, conductor.getX(), conductor.getY(), conductor.getZ(), conductor.getYRot(), conductor.getXRot());
                    return;
                }
                AABB aABB = conductor.getBoundingBox();
                m = d - conductor.lastGoodX;
                n = e - conductor.lastGoodY;
                o = f - conductor.lastGoodZ;
                boolean bl = bl2 = n > 0.0;
                if (conductor.onGround() && !this.move.isOnGround() && bl2) {
                    conductor.jumpFromGround();
                }
                boolean bl22 = conductor.verticalCollisionBelow;
                conductor.move(MoverType.PLAYER, new Vec3(m, n, o));
                double t = n;
                m = d - conductor.getX();
                n = e - conductor.getY();
                if (n > -0.5 || n < 0.5) {
                    n = 0.0;
                }
                o = f - conductor.getZ();
                q = m * m + n * n + o * o;
                boolean bl3 = false;
                if (q > 0.0625) {
                    bl3 = true;
                    return;
                }
                conductor.absMoveTo(d, e, f, g, h);
                if (!conductor.noPhysics && (bl3 && serverLevel.noCollision((Entity)conductor, aABB) || CameraMovePacket.isPlayerCollidingWithAnythingNew(conductor, (LevelReader)serverLevel, aABB))) {
                    CameraMovePacket.teleport(sender1, conductor, i, j, k, g, h);
                    return;
                }
                conductor.doCheckFallDamage(conductor.getY() - l, this.move.isOnGround());
                conductor.setOnGround(this.move.isOnGround());
                if (bl2) {
                    conductor.resetFallDistance();
                }
                conductor.lastGoodX = conductor.getX();
                conductor.lastGoodY = conductor.getY();
                conductor.lastGoodZ = conductor.getZ();
            }
        }
    }

    static final class MoveData {
        final double x;
        final double y;
        final double z;
        final float yaw;
        final float pitch;
        final boolean onGround;

        MoveData(double x, double y, double z, float yaw, float pitch, boolean onGround) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.onGround = onGround;
        }

        double getX(double base) {
            return this.x;
        }

        double getY(double base) {
            return this.y;
        }

        double getZ(double base) {
            return this.z;
        }

        float getYRot(float base) {
            return this.yaw;
        }

        float getXRot(float base) {
            return this.pitch;
        }

        boolean isOnGround() {
            return this.onGround;
        }
    }
}

