/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomSpriteManager;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CustomTrackOverlayRendering {
    public static final Map<EdgePointType<?>, PartialModel> CUSTOM_OVERLAYS = new HashMap();

    public static void register(EdgePointType<?> edgePointType, PartialModel model) {
        CUSTOM_OVERLAYS.put(edgePointType, model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, EdgePointType<?> type, float scale) {
        if (CUSTOM_OVERLAYS.containsKey(type)) {
            CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, CUSTOM_OVERLAYS.get(type), scale, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale) {
        CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, model, scale, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale, boolean offsetToSide) {
        if (level instanceof SchematicLevel && !(level instanceof PonderLevel)) {
            return;
        }
        BlockState trackState = level.getBlockState(pos);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.pushPose();
        PartialModel partial = CustomTrackOverlayRendering.prepareTrackOverlay((BlockGetter)level, pos, trackState, bezier, direction, ms, model);
        if (partial != null) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)partial, (BlockState)trackState).translate(0.5, 0.0, 0.5)).scale(scale)).translate(offsetToSide ? 0.5 : -0.5, 0.0, -0.5)).light(LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos)).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
        ms.popPose();
    }

    /*
     * Unable to fully structure code
     */
    @OnlyIn(value=Dist.CLIENT)
    public static PartialModel prepareTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, PartialModel model) {
        msr = TransformStack.of((PoseStack)ms);
        axis = null;
        diff = null;
        normal = null;
        offset = null;
        if (bezierPoint != null && (var13_12 = world.getBlockEntity(pos)) instanceof TrackBlockEntity) {
            trackTE = (TrackBlockEntity)var13_12;
            bc = (BezierConnection)trackTE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                if (bc.getMaterial() == CRTrackMaterials.PHANTOM && !PhantomSpriteManager.isVisible()) {
                    return null;
                }
                length = Mth.floor((double)(bc.getLength() * 2.0));
                seg = bezierPoint.segment() + 1;
                t = (double)seg / length;
                tpre = (double)(seg - 1) / length;
                tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).subtract(bc.getPosition(tpre)).normalize();
                msr.translate(offset.subtract(Vec3.atBottomCenterOf((Vec3i)pos)));
                msr.translate(0.0f, -0.25f, 0.0f);
                casingBc = (IHasTrackCasing)bc;
                if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                    msr.translate(0.0f, 0.875f, 0.0f);
                } else if (casingBc.getTrackCasing() != null) {
                    if (((BlockPos)bc.bePositions.getFirst()).getY() == ((BlockPos)bc.bePositions.getSecond()).getY()) {
                        msr.translate(0.0f, 0.0625f, 0.0f);
                    } else if (!casingBc.isAlternate()) {
                        msr.translate(0.0f, 0.25f, 0.0f);
                    }
                }
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = (Vec3)((TrackShape)state.getValue((Property)TrackBlock.SHAPE)).getAxes().get(0);
            diff = axis.scale((double)direction.getStep()).normalize();
            normal = ((ITrackBlock)state.getBlock()).getUpNormal(world, pos, state);
        }
        if ((bc = state.getBlock()) instanceof TrackBlock && (track = (TrackBlock)bc).getMaterial() == CRTrackMaterials.PHANTOM && !PhantomSpriteManager.isVisible()) {
            return null;
        }
        if (bezierPoint != null || !((var15_27 = state.getBlock()) instanceof TrackBlock)) ** GOTO lbl-1000
        trackBlock = (TrackBlock)var15_27;
        if (trackBlock.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            msr.translate(0.0f, 0.875f, 0.0f);
        } else if (bezierPoint == null && (var15_27 = world.getBlockEntity(pos)) instanceof TrackBlockEntity) {
            trackTE = (TrackBlockEntity)var15_27;
            var15_27 = state.getBlock();
            if (var15_27 instanceof TrackBlock) {
                trackBlock = (TrackBlock)var15_27;
                casingTE = (IHasTrackCasing)trackTE;
                shape = (TrackShape)state.getValue((Property)TrackBlock.SHAPE);
                if (casingTE.getTrackCasing() != null) {
                    spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                    trackType = trackBlock.getMaterial().trackType;
                    if (spec != null) {
                        msr.translate(spec.getXShift(trackType), (double)((float)(spec.getTopSurfacePixelHeight(trackType, casingTE.isAlternate()) - 2) / 16.0f), spec.getZShift(trackType));
                    }
                }
            }
        }
        angles = TrackRenderer.getModelAngles(normal, diff);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateY((float)angles.y)).rotateX((float)angles.x)).uncenter();
        if (axis != null) {
            msr.translate(0.0f, axis.y != 0.0 ? 0.4375f : 0.0f, axis.y != 0.0 ? (float)direction.getStep() * 2.5f / 16.0f : 0.0f);
        } else {
            msr.translate(0.0f, 0.25f, 0.0f);
            if (direction == Direction.AxisDirection.NEGATIVE) {
                msr.rotateCentered(3.1415927f, Direction.UP);
            }
        }
        if (bezierPoint == null && (trackBlock = world.getBlockEntity(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)trackBlock).isTilted()) {
            yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((Vec3)bc.starts.getFirst()).y - (double)pos.getY();
            }
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateXDegrees((float)((double)(-direction.getStep()) * (Double)trackTE.tilt.smoothingAngle.get()))).uncenter()).translate(0.0, yOffset / 2.0, 0.0);
        }
        return model;
    }

    public static boolean overlayWillOverlap(TrackTargetingBehaviour<? extends TrackEdgePoint> target) {
        try {
            TrackGraphLocation graphLocation = target.determineGraphLocation();
            TrackEdge edge = (TrackEdge)graphLocation.graph.getConnectionsFrom(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getFirst())).get(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getSecond()));
            for (TrackEdgePoint edgePoint : edge.getEdgeData().getPoints()) {
                try {
                    double d = edgePoint.getLocationOn(edge);
                    double d2 = target.getEdgePoint() != null ? target.getEdgePoint().getLocationOn(edge) : graphLocation.position;
                    if (!(Math.abs(d - d2) < 0.75) || edgePoint == target.getEdgePoint() || edgePoint.getId().equals(target.getEdgePoint().getId())) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

