/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.google.common.collect.ImmutableMap;
import com.railwayteam.railways.util.neoforge.BlockStateUtilsImpl;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateUtils {
    private static final Map<Block, DyeColor> WOOL_MAP = ImmutableMap.builder().putAll((Map)ImmutableMap.of((Object)Blocks.RED_WOOL, (Object)DyeColor.RED, (Object)Blocks.ORANGE_WOOL, (Object)DyeColor.ORANGE, (Object)Blocks.YELLOW_WOOL, (Object)DyeColor.YELLOW, (Object)Blocks.LIME_WOOL, (Object)DyeColor.LIME, (Object)Blocks.GREEN_WOOL, (Object)DyeColor.GREEN, (Object)Blocks.LIGHT_BLUE_WOOL, (Object)DyeColor.LIGHT_BLUE, (Object)Blocks.CYAN_WOOL, (Object)DyeColor.CYAN, (Object)Blocks.BLUE_WOOL, (Object)DyeColor.BLUE)).putAll((Map)ImmutableMap.of((Object)Blocks.PURPLE_WOOL, (Object)DyeColor.PURPLE, (Object)Blocks.MAGENTA_WOOL, (Object)DyeColor.MAGENTA, (Object)Blocks.PINK_WOOL, (Object)DyeColor.PINK, (Object)Blocks.BROWN_WOOL, (Object)DyeColor.BROWN, (Object)Blocks.BLACK_WOOL, (Object)DyeColor.BLACK, (Object)Blocks.GRAY_WOOL, (Object)DyeColor.GRAY, (Object)Blocks.LIGHT_GRAY_WOOL, (Object)DyeColor.LIGHT_GRAY, (Object)Blocks.WHITE_WOOL, (Object)DyeColor.WHITE)).build();
    private static final Map<DyeColor, Block> WOOL_MAP_REVERSE = new HashMap<DyeColor, Block>();

    public static BlockState trackWith(TrackBlock block, BlockState state) {
        return (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)TrackBlock.SHAPE, (Comparable)((TrackShape)state.getValue((Property)TrackBlock.SHAPE)))).setValue((Property)TrackBlock.HAS_BE, (Comparable)((Boolean)state.getValue((Property)TrackBlock.HAS_BE)))).setValue((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)ProperWaterloggedBlock.WATERLOGGED)));
    }

    public static SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return BlockStateUtilsImpl.getSoundType(state, level, pos, entity);
    }

    public static DyeColor getWoolColor(Block block) {
        return WOOL_MAP.getOrDefault(block, DyeColor.WHITE);
    }

    public static Block getWoolBlock(DyeColor color) {
        return WOOL_MAP_REVERSE.getOrDefault(color, Blocks.WHITE_WOOL);
    }

    static {
        for (Map.Entry<Block, DyeColor> entry : WOOL_MAP.entrySet()) {
            WOOL_MAP_REVERSE.put(entry.getValue(), entry.getKey());
        }
    }
}

