/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.distant_signals.SignalDisplaySource;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.neoforge.CRExtraRegistrationImpl;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CRExtraRegistration {
    public static boolean registeredSignalSource = false;
    public static boolean registeredVentAsCopycat = false;

    public static void addVentAsCopycat(BlockEntityType<?> object) {
        Block ventBlock;
        if (registeredVentAsCopycat) {
            return;
        }
        try {
            ventBlock = (Block)CRBlocks.CONDUCTOR_VENT.get();
        }
        catch (NullPointerException ignored) {
            return;
        }
        ImmutableSet validBlocks = ((AccessorBlockEntityType)object).getValidBlocks();
        validBlocks = new ImmutableSet.Builder().add((Object[])((Block[])validBlocks.toArray(Block[]::new))).add((Object)ventBlock).build();
        ((AccessorBlockEntityType)object).setValidBlocks((Set<Block>)validBlocks);
        registeredVentAsCopycat = true;
    }

    public static void addSignalSource(Block block) {
        if (registeredSignalSource) {
            return;
        }
        SignalDisplaySource source = new SignalDisplaySource();
        Railways.registrate().displaySource("track_signal_source", () -> source).register();
        DisplaySource.BY_BLOCK.add((Object)block, (Object)source);
        registeredSignalSource = true;
    }

    public static void platformSpecificRegistration() {
        CRExtraRegistrationImpl.platformSpecificRegistration();
    }
}

