/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge.events;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.mixin.AccessorToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConductorItemHandler
implements IItemHandler {
    private final ConductorEntity conductor;

    ConductorItemHandler(ConductorEntity conductor) {
        this.conductor = conductor;
    }

    @Nullable
    private ToolboxInventory inv() {
        MountedToolbox tb = this.conductor.getToolbox();
        if (tb == null) {
            return null;
        }
        if (tb instanceof AccessorToolboxBlockEntity) {
            AccessorToolboxBlockEntity accessor = (AccessorToolboxBlockEntity)((Object)tb);
            return accessor.getInventory();
        }
        return null;
    }

    public int getSlots() {
        ToolboxInventory inv = this.inv();
        return inv != null ? inv.getSlots() : 0;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ToolboxInventory inv = this.inv();
        return inv != null ? inv.getStackInSlot(slot) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ToolboxInventory inv = this.inv();
        return inv != null ? inv.insertItem(slot, stack, simulate) : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ToolboxInventory inv = this.inv();
        return inv != null ? inv.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        ToolboxInventory inv = this.inv();
        return inv != null ? inv.getSlotLimit(slot) : 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        ToolboxInventory inv = this.inv();
        return inv != null && inv.isItemValid(slot, stack);
    }
}

