/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationRenderer;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationRenderer.class})
public class MixinStationRenderer {
    @Inject(method={"renderSafe(Lcom/simibubi/create/content/trains/station/StationBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/render/CachedBuffers;partial(Ldev/engine_room/flywheel/lib/model/baked/PartialModel;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/createmod/catnip/render/SuperByteBuffer;")})
    private void shiftAssemblyOverlayOnEncasedTracks(StationBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, CallbackInfo ci, @Local(name={"currentPos"}) BlockPos.MutableBlockPos currentPos, @Local(name={"trackState"}) BlockState trackState) {
        ms.pushPose();
        Block block = trackState.getBlock();
        if (block instanceof TrackBlock) {
            IHasTrackCasing casing;
            TrackBlock trackBlock = (TrackBlock)block;
            block = be.getLevel().getBlockEntity((BlockPos)currentPos);
            if (block instanceof IHasTrackCasing && (casing = (IHasTrackCasing)block).getTrackCasing() != null) {
                TrackShape shape = (TrackShape)trackState.getValue((Property)TrackBlock.SHAPE);
                CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                TrackMaterial.TrackType trackType = trackBlock.getMaterial().trackType;
                if (spec != null) {
                    TransformStack.of((PoseStack)ms).translate(spec.getXShift(trackType), (double)((float)(spec.getTopSurfacePixelHeight(trackType, casing.isAlternate()) - 2) / 16.0f), spec.getZShift(trackType));
                }
            }
        }
    }

    @Inject(method={"renderSafe(Lcom/simibubi/create/content/trains/station/StationBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/render/SuperByteBuffer;renderInto(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V", shift=At.Shift.AFTER)})
    private void cleanup(StationBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, CallbackInfo ci) {
        ms.popPose();
    }
}

