/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerServer;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StationBlockEntity.class}, remap=false)
public abstract class MixinStationBlockEntity
extends SmartBlockEntity {
    private Train dropScheduleTrain;

    @Shadow
    @Nullable
    public abstract GlobalStation getStation();

    private MixinStationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"trackClicked"}, at={@At(value="HEAD")})
    private void storePlayer(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyMenuHandlerServer.setCurrentPlayer(player.getUUID());
    }

    @Inject(method={"trackClicked"}, at={@At(value="RETURN")})
    private void clearPlayer(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyMenuHandlerServer.setCurrentPlayer(null);
    }

    @Inject(method={"trackClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=true, require=0)
    private void railways$setBogeyData(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir, BoundingBox bb, BlockPos up, BlockPos down, int bogeyOffset, ItemStack handItem, boolean upsideDown, BlockPos targetPos) {
        TrackMaterial.TrackType trackType;
        if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            return;
        }
        Pair<BogeyStyle, BogeySizes.BogeySize> styleData = BogeyMenuHandlerServer.getStyle(player.getUUID());
        BogeyStyle style = (BogeyStyle)styleData.getFirst();
        Optional<BogeyStyle> mappedStyleOptional = CRBogeyStyles.getMapped(style, trackType = track.getMaterial().trackType, true);
        if (mappedStyleOptional.isPresent()) {
            style = mappedStyleOptional.get();
        }
        if (style == AllBogeyStyles.STANDARD) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(targetPos);
        if (blockEntity instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity bogeyBE = (AbstractBogeyBlockEntity)blockEntity;
            bogeyBE.setBogeyStyle(style);
        }
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;")})
    private void storeTrainForDropping(ServerPlayer sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = this.getStation() == null ? null : this.getStation().getPresentTrain();
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="RETURN")})
    private void clearDropTrain(ServerPlayer sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = null;
    }

    @ModifyReceiver(method={"dropSchedule"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;runtime:Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;")}, require=0)
    private Train returnOverridenTrain(Train instance) {
        Train train = instance != null ? instance : this.dropScheduleTrain;
        this.dropScheduleTrain = null;
        return train;
    }

    @Inject(method={"assemble"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0)}, require=0)
    private void allowAssemblingWithoutControls(UUID playerUUID, CallbackInfo ci, @Local(name={"typeOfFirstBogey"}) AbstractBogeyBlock<?> typeOfFirstBogey, @Local(name={"atLeastOneForwardControls"}) LocalBooleanRef atLeastOneForwardControls) {
        if (typeOfFirstBogey instanceof HandcarBlock) {
            atLeastOneForwardControls.set(true);
        }
    }

    @Inject(method={"applyAutoSchedule"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;setSchedule(Lcom/simibubi/create/content/trains/schedule/Schedule;Z)V")})
    private void setScheduleIndexOnAutoSchedule(CallbackInfo ci, @Local Train imminentTrain) {
        int idx = 0;
        ((IIndexedSchedule)imminentTrain).railways$setIndex(0);
        for (Carriage carriage : imminentTrain.carriages) {
            if (carriage.presentConductors.either(b -> b)) {
                ((IIndexedSchedule)imminentTrain).railways$setIndex(idx);
                if (!Utils.isDevEnv()) break;
                Railways.LOGGER.info("[SET_INDEX {}] on train {} called in MixinStationBlockEntity#setScheduleIndexOnAutoSchedule", (Object)idx, (Object)imminentTrain.name.getString());
                break;
            }
            ++idx;
        }
    }
}

