/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.util.EntityUtils;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SemaphoreItem
extends BlockItem {
    public SemaphoreItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult place(BlockPlaceContext pContext) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)SemaphoreBlock.placementHelperId);
        Level world = pContext.getLevel();
        Player player = pContext.getPlayer();
        BlockPos pos = pContext.getClickedPos();
        if (!pContext.replacingClickedOnBlock()) {
            pos = pos.offset(pContext.getClickedFace().getOpposite().getNormal());
        }
        BlockState state = world.getBlockState(pos);
        double pHitDistance = EntityUtils.getReachDistance(player);
        Vec3 eyePos = player.getEyePosition();
        Vec3 viewVec = player.getViewVector(0.0f);
        Vec3 endPos = eyePos.add(viewVec.x * pHitDistance, viewVec.y * pHitDistance, viewVec.z * pHitDistance);
        BlockHitResult ray = pContext.getLevel().clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (!placementHelper.matchesState(state)) {
            return super.place(pContext);
        }
        ItemInteractionResult result = placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, pContext.getHand(), ray);
        if (result.consumesAction()) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.place(pContext);
    }
}

