/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.schedule;

import com.railwayteam.railways.Railways;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.station.GlobalStation;
import net.createmod.catnip.data.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StationLoadedCondition
extends ScheduleWaitCondition {
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)ItemStack.EMPTY, (Object)Component.translatable((String)"railways.schedule.condition.loaded"));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        GlobalStation currentStation = train.getCurrentStation();
        if (currentStation == null) {
            return false;
        }
        ResourceKey stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = level.getServer();
        if (server == null) {
            return false;
        }
        ServerLevel stationLevel = server.getLevel(stationDim);
        if (stationLevel == null) {
            return false;
        }
        return stationLevel.isPositionEntityTicking(currentStation.getBlockEntityPos());
    }

    public ResourceLocation getId() {
        return Railways.asResource("loaded");
    }

    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        return Component.translatable((String)"railways.schedule.condition.unloaded.status");
    }
}

