/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.minecarts;

import com.railwayteam.railways.content.minecarts.MinecartBlock;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.util.packet.PacketSender;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class MinecartJukebox
extends MinecartBlock {
    public static AbstractMinecart.Type TYPE = null;
    private static final int COOLDOWN = 100;
    private static final int PARTICLE_INTERVAL = 20;
    private int cooldownCount = 0;
    private long ticksSinceSongStarted = 0L;
    private ItemStack disc = ItemStack.EMPTY;
    @OnlyIn(value=Dist.CLIENT)
    private JukeboxCartSoundInstance sound;

    public static AbstractMinecart.Type getJukeboxType() {
        if (TYPE == null) {
            TYPE = AbstractMinecart.Type.valueOf((String)"RAILWAY_JUKEBOX");
        }
        return TYPE;
    }

    public MinecartJukebox(EntityType<?> type, Level level) {
        super(type, level, Blocks.JUKEBOX);
    }

    public MinecartJukebox(Level level, double x, double y, double z) {
        super((EntityType)CREntities.CART_JUKEBOX.get(), level, x, y, z, Blocks.JUKEBOX);
    }

    public int getComparatorOutput() {
        JukeboxPlayable playable = (JukeboxPlayable)this.disc.get(DataComponents.JUKEBOX_PLAYABLE);
        if (playable != null) {
            return playable.song().holder().map(Holder::value).map(JukeboxSong::comparatorOutput).orElse(0);
        }
        return 0;
    }

    public AbstractMinecart.Type getMinecartType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        if (this.cooldownCount > 0) {
            --this.cooldownCount;
        }
        if (!this.disc.isEmpty()) {
            if (!this.level().isClientSide && this.ticksSinceSongStarted % 20L == 0L) {
                this.spawnMusicParticles();
            }
            ++this.ticksSinceSongStarted;
        }
    }

    private void spawnMusicParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double offsetX = (this.level().getRandom().nextDouble() - 0.5) * 0.5;
            double offsetZ = (this.level().getRandom().nextDouble() - 0.5) * 0.5;
            Vec3 pos = this.position().add(offsetX, 1.2, offsetZ);
            float noteColor = (float)this.level().getRandom().nextInt(4) / 24.0f;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.NOTE, pos.x(), pos.y(), pos.z(), 0, (double)noteColor, 0.0, 0.0, 1.0);
        }
    }

    public void activateMinecart(int x, int y, int z, boolean active) {
        if (active && !this.level().isClientSide && this.cooldownCount <= 0) {
            this.cooldownCount = 100;
            PacketSender.updateJukeboxClientside(this, this.disc);
        }
    }

    public ItemStack getPickResult() {
        return CRItems.ITEM_JUKEBOXCART.asStack();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            return ret;
        }
        if (this.level().isClientSide) return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        if (this.disc.isEmpty()) {
            ItemStack handStack = player.getItemInHand(hand);
            if (!handStack.has(DataComponents.JUKEBOX_PLAYABLE)) return InteractionResult.PASS;
            this.insertRecord(handStack);
            if (!player.isCreative()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            player.awardStat(Stats.PLAY_RECORD);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        } else {
            this.__ejectRecord();
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Disc", 10)) {
            this.disc = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("Disc"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.disc.isEmpty()) {
            compound.put("Disc", this.disc.save((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    public void insertRecord(ItemStack record) {
        this.disc = record.copy();
        this.ticksSinceSongStarted = 0L;
        if (this.content == null) {
            this.content = Blocks.JUKEBOX.defaultBlockState();
        }
        this.content = (BlockState)this.content.setValue((Property)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(!this.disc.isEmpty()));
        if (!this.level().isClientSide) {
            if (!this.disc.isEmpty()) {
                PacketSender.updateJukeboxClientside(this, this.disc);
            }
        } else if (!this.disc.isEmpty()) {
            if (this.sound == null || this.sound.isStopped()) {
                this.startPlaying();
            } else {
                this.sound.requestStop();
            }
        } else if (this.sound != null) {
            this.sound.requestStop();
        }
    }

    private void __ejectRecord() {
        if (this.level().isClientSide) {
            return;
        }
        Vector3d pos = new Vector3d(this.position().x + 0.5, this.position().y + 1.0, this.position().z + 0.5);
        ItemEntity out = new ItemEntity(this.level(), pos.x, pos.y, pos.z, this.disc);
        out.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)out);
        this.insertRecord(ItemStack.EMPTY);
    }

    private void __insertRecord(ItemStack record) {
        this.insertRecord(record);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startPlaying() {
        if (!this.disc.isEmpty()) {
            JukeboxPlayable playable = (JukeboxPlayable)this.disc.get(DataComponents.JUKEBOX_PLAYABLE);
            if (playable == null) {
                return;
            }
            EitherHolder songHolder = playable.song();
            Optional<Holder.Reference> holderOptional = songHolder.holder();
            if (holderOptional.isEmpty()) {
                try {
                    Class<?> holderClass = songHolder.getClass();
                    Field keyField = holderClass.getDeclaredField("key");
                    keyField.setAccessible(true);
                    Object keyValue = keyField.get(songHolder);
                    if (keyValue != null) {
                        ResourceKey resourceKey;
                        RegistryAccess registryAccess;
                        Registry registry;
                        Optional resolvedHolderRef;
                        Minecraft mc = Minecraft.getInstance();
                        if (mc.level != null && (resolvedHolderRef = (registry = (registryAccess = mc.level.registryAccess()).registryOrThrow(Registries.JUKEBOX_SONG)).getHolder(resourceKey = (ResourceKey)keyValue)).isPresent()) {
                            Holder.Reference holderRef = (Holder.Reference)resolvedHolderRef.get();
                            holderOptional = Optional.of(holderRef);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (holderOptional.isEmpty()) {
                    return;
                }
            }
            holderOptional.map(holder -> {
                JukeboxSong song = (JukeboxSong)holder.value();
                SoundEvent soundEvent = (SoundEvent)song.soundEvent().value();
                return soundEvent;
            }).ifPresent(soundEvent -> {
                if (soundEvent != null) {
                    this.sound = new JukeboxCartSoundInstance((SoundEvent)soundEvent);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)this.sound);
                }
            });
        }
    }

    public void destroy(@NotNull DamageSource source) {
        super.destroy(source);
        if (!source.is(DamageTypeTags.IS_EXPLOSION) && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && this.disc != null && !this.disc.isEmpty()) {
            this.spawnAtLocation(this.disc.copy());
            this.disc = ItemStack.EMPTY;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class JukeboxCartSoundInstance
    extends AbstractTickableSoundInstance {
        public JukeboxCartSoundInstance(SoundEvent event) {
            super(event, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
            this.x = (double)MinecartJukebox.this.blockPosition().getX() + 0.5;
            this.y = (double)MinecartJukebox.this.blockPosition().getY() + 0.5;
            this.z = (double)MinecartJukebox.this.blockPosition().getZ() + 0.5;
            this.looping = false;
            this.delay = 0;
            this.volume = 1.0f;
            this.pitch = 1.0f;
        }

        public void tick() {
            if (MinecartJukebox.this.isRemoved()) {
                this.requestStop();
                return;
            }
            this.x = (double)MinecartJukebox.this.blockPosition().getX() + 0.5;
            this.y = (double)MinecartJukebox.this.blockPosition().getY() + 0.5;
            this.z = (double)MinecartJukebox.this.blockPosition().getZ() + 0.5;
        }

        public void requestStop() {
            this.stop();
        }
    }
}

