/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.monobogey;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlockEntity;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractMonoBogeyBlock<T extends MonoBogeyBlockEntity>
extends AbstractBogeyBlock<T>
implements IBE<T>,
ProperWaterloggedBlock,
SpecialBlockItemRequirement {
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    private final List<Property<?>> properties_to_copy = ImmutableList.builder().addAll((Iterable)super.propertiesToCopy()).add((Object)UPSIDE_DOWN).build();

    public AbstractMonoBogeyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, BogeySizes.SMALL);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getVersion(BlockState base, boolean upsideDown) {
        if (!base.hasProperty((Property)UPSIDE_DOWN)) {
            return base;
        }
        return (BlockState)base.setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown));
    }

    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return CRTrackMaterials.CRTrackType.MONORAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UPSIDE_DOWN});
        super.createBlockStateDefinition(builder);
    }

    public double getWheelPointSpacing() {
        return 2.0;
    }

    public double getWheelRadius() {
        return 0.375;
    }

    public Vec3 getConnectorAnchorOffset(boolean upsideDown) {
        return new Vec3(0.0, upsideDown ? 0.65625 : 0.34375, 1.0);
    }

    public Vec3 getConnectorAnchorOffset() {
        return this.getConnectorAnchorOffset(false);
    }

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public BlockState getRotatedBlockState(BlockState state, Direction targetedFace) {
        return state;
    }

    public boolean canBeUpsideDown() {
        return true;
    }

    public boolean isUpsideDown(BlockState state) {
        return state.hasProperty((Property)UPSIDE_DOWN) && (Boolean)state.getValue((Property)UPSIDE_DOWN) != false;
    }

    public List<Property<?>> propertiesToCopy() {
        return this.properties_to_copy;
    }
}

