/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.neoforge.TrackCouplerBlockImpl;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrackCouplerBlock
extends Block
implements IBE<TrackCouplerBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<TrackCouplerBlockEntity.AllowedOperationMode> MODE = EnumProperty.create((String)"mode", TrackCouplerBlockEntity.AllowedOperationMode.class);

    protected TrackCouplerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(MODE, (Comparable)((Object)TrackCouplerBlockEntity.AllowedOperationMode.BOTH)));
    }

    public static TrackCouplerBlock create(BlockBehaviour.Properties properties) {
        return TrackCouplerBlockImpl.create(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{POWERED}).add(new Property[]{MODE}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(pContext.getLevel().hasNeighborSignal(pContext.getClickedPos())));
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackCouplerBlockEntity) {
            TrackCouplerBlockEntity te = (TrackCouplerBlockEntity)blockEntity;
            return te.getTargetAnalogOutput();
        }
        return 0;
    }

    public Class<TrackCouplerBlockEntity> getBlockEntityClass() {
        return TrackCouplerBlockEntity.class;
    }

    public BlockEntityType<? extends TrackCouplerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.TRACK_COUPLER.get();
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.isClientSide) {
            return;
        }
        boolean powered = (Boolean)pState.getValue((Property)POWERED);
        if (powered == pLevel.hasNeighborSignal(pPos)) {
            return;
        }
        if (powered) {
            pLevel.scheduleTick(pPos, (Block)this, 4);
        } else {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue() && !pLevel.hasNeighborSignal(pPos)) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState newState = (BlockState)state.cycle(MODE);
        level.setBlock(pos, newState, 3);
        Player player = context.getPlayer();
        if (player != null) {
            player.displayClientMessage(((TrackCouplerBlockEntity.AllowedOperationMode)((Object)newState.getValue(MODE))).getTranslatedName(), true);
        }
        return InteractionResult.SUCCESS;
    }
}

