/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlockEntity;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ConductorWhistleFlagRenderer
extends SmartBlockEntityRenderer<ConductorWhistleFlagBlockEntity> {
    public ConductorWhistleFlagRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ConductorWhistleFlagBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderEdgePoint(te, ms, buffer, light, overlay);
    }

    private void renderEdgePoint(ConductorWhistleFlagBlockEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        TrackTargetingBehaviour<GlobalStation> target = te.station;
        BlockPos pos = te.getBlockPos();
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = te.getLevel();
        BlockState trackState = level.getBlockState(targetPosition);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.pushPose();
        ms.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        CustomTrackOverlayRendering.renderOverlay((LevelAccessor)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, AllPartialModels.TRACK_STATION_OVERLAY, 1.0f, false);
        ms.popPose();
    }
}

