/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock.neoforge;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.neoforge.CopycatHeadstockBarsModel;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.content.decoration.copycat.FilteredBlockAndTintGetter;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class CopycatHeadstockModel
implements BakedModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);
    private final BakedModel wrapped;
    private static final ModelProperty<@Nullable BlockState> MATERIAL = CopycatModel.MATERIAL_PROPERTY;
    private static final ModelProperty<@Nullable DyeColor> COLOR = new ModelProperty();
    private static final ModelProperty<OcclusionData> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<ModelData> WRAPPED_DATA_PROPERTY = new ModelProperty();

    public CopycatHeadstockModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        CopycatBlock copycatBlock;
        BlockState material;
        ModelData.Builder builder;
        block5: {
            block4: {
                DyeColor color = null;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof IDyedBuffer) {
                    IDyedBuffer be = (IDyedBuffer)blockEntity;
                    color = be.getColor();
                }
                builder = modelData.derive().with(COLOR, color);
                material = CopycatHeadstockModel.getMaterial(modelData);
                Block block = state.getBlock();
                if (!(block instanceof CopycatBlock)) break block4;
                copycatBlock = (CopycatBlock)block;
                if (material != null) break block5;
            }
            return builder.build();
        }
        OcclusionData occlusionData = new OcclusionData();
        this.gatherOcclusionData(level, pos, state, material, occlusionData, copycatBlock);
        builder.with(OCCLUSION_PROPERTY, (Object)occlusionData);
        ModelData wrappedData = CopycatModel.getModelOf((BlockState)material).getModelData((BlockAndTintGetter)new FilteredBlockAndTintGetter(level, targetPos -> copycatBlock.canConnectTexturesToward(level, pos, targetPos, state)), pos, material, ModelData.EMPTY);
        return builder.with(WRAPPED_DATA_PROPERTY, (Object)wrappedData).build();
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, OcclusionData occlusionData, CopycatBlock copycatBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.setWithOffset((Vec3i)pos, face);
            BlockState neighbourState = world.getBlockState((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, state, face.getOpposite())) {
                occlusionData.occlude(face);
                continue;
            }
            if (!copycatBlock.canFaceBeOccluded(state, face) || Block.shouldRenderFace((BlockState)material, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        DyeColor color = (DyeColor)data.get(COLOR);
        ArrayList<BakedQuad> quads = color != null ? new ArrayList<BakedQuad>(CopycatHeadstockModel.filterQuads(CopycatHeadstockModel::filterCopycatParts, BakedModelHelper.swapSprites((List)this.wrapped.getQuads(state, side, rand), BufferModelUtils.getSwapper(color)))) : new ArrayList<BakedQuad>(CopycatHeadstockModel.filterQuads(CopycatHeadstockModel::filterCopycatParts, this.wrapped.getQuads(state, side, rand)));
        quads.addAll(this.getCopycatExtensionQuads(state, side, rand, data, renderType));
        return ImmutableList.copyOf(quads);
    }

    @NotNull
    public static BlockState getMaterial(@Nullable ModelData data) {
        BlockState material = data == null ? null : (BlockState)data.get(MATERIAL);
        return material == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    private List<BakedQuad> getCopycatExtensionQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        Direction[] directionArray;
        CopycatBlock ccb;
        Block block;
        if (side != null && (block = state.getBlock()) instanceof CopycatBlock && (ccb = (CopycatBlock)block).shouldFaceAlwaysRender(state, side)) {
            return Collections.emptyList();
        }
        BlockState material = CopycatHeadstockModel.getMaterial(data);
        OcclusionData occlusionData = (OcclusionData)data.get(OCCLUSION_PROPERTY);
        if (occlusionData != null && occlusionData.isOccluded(side)) {
            return List.of();
        }
        ModelData wrappedData = (ModelData)data.get(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = ModelData.EMPTY;
        }
        if (renderType != null && !Minecraft.getInstance().getBlockRenderer().getBlockModel(material).getRenderTypes(material, rand, wrappedData).contains(renderType)) {
            return List.of();
        }
        List<BakedQuad> croppedQuads = this.getCroppedQuads(state, side, rand, material, wrappedData, renderType);
        if (side == null && (directionArray = state.getBlock()) instanceof CopycatBlock) {
            CopycatBlock ccb2 = (CopycatBlock)directionArray;
            for (Direction nonOcclusionSide : Iterate.directions) {
                if (!ccb2.shouldFaceAlwaysRender(state, nonOcclusionSide)) continue;
                croppedQuads.addAll(this.getCroppedQuads(state, nonOcclusionSide, rand, material, wrappedData, renderType));
            }
        }
        return croppedQuads;
    }

    protected List<BakedQuad> getCroppedQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, BlockState material, ModelData wrappedData, @Nullable RenderType renderType) {
        BlockState specialState;
        BakedModel specialModel;
        boolean upsideDown;
        Direction facing = state == null ? Direction.NORTH : state.getOptionalValue((Property)CopycatHeadstockBlock.FACING).orElse(Direction.NORTH);
        boolean bl = upsideDown = state != null && (Boolean)state.getValue((Property)CopycatHeadstockBlock.UPSIDE_DOWN) != false;
        if (CopycatSpecialCases.isBarsMaterial((BlockState)material) && (specialModel = CopycatModel.getModelOf((BlockState)(specialState = (BlockState)((BlockState)CRBlocks.COPYCAT_HEADSTOCK_BARS.getDefaultState().setValue((Property)CopycatHeadstockBlock.FACING, (Comparable)facing)).setValue((Property)CopycatHeadstockBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown))))) instanceof CopycatHeadstockBarsModel) {
            CopycatHeadstockBarsModel cm = (CopycatHeadstockBarsModel)specialModel;
            return cm.getCroppedQuads(state, side, rand, material, wrappedData, renderType);
        }
        BakedModel model = CopycatModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        Vec3 normalScaled14 = normal.scale(0.875);
        for (boolean top : Iterate.trueAndFalse) {
            for (boolean front : Iterate.trueAndFalse) {
                Vec3 offset = normal.scale(front ? 0.0 : -0.8125);
                float contract = 16 - (front ? 1 : 2);
                AABB bb = CUBE_AABB.contract(normal.x * (double)contract / 16.0, 0.625, normal.z * (double)contract / 16.0);
                if (!front) {
                    bb = bb.move(normalScaled14);
                }
                if (top) {
                    bb = bb.move(0.0, 0.625, 0.0);
                } else {
                    offset = offset.add(0.0, 0.25, 0.0);
                }
                if (upsideDown) {
                    offset = offset.add(0.0, -0.25, 0.0);
                }
                for (int i = 0; i < size; ++i) {
                    BakedQuad quad = (BakedQuad)templateQuads.get(i);
                    Direction direction = quad.getDirection();
                    if (front && direction == facing || !front && direction == facing.getOpposite() || top && direction == Direction.DOWN || !top && direction == Direction.UP) continue;
                    quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb, (Vec3)offset)));
                }
            }
        }
        return quads;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    private static boolean filterCopycatParts(BakedQuad quad) {
        return !quad.getSprite().contents().name().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"create", (String)"block/copycat_base"));
    }

    @NotNull
    private static List<BakedQuad> filterQuads(@NotNull Predicate<BakedQuad> filter, @NotNull List<BakedQuad> quads) {
        return quads.stream().filter(filter).toList();
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        CompoundTag tag;
        BlockState material = AllBlocks.COPYCAT_BASE.getDefaultState();
        UnaryOperator<TextureAtlasSprite> colorSwapper = null;
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && (tag = customData.copyTag()).contains("BlockEntityTag", 10)) {
            CompoundTag blockEntityTag = tag.getCompound("BlockEntityTag");
            if (blockEntityTag.contains("Material", 10)) {
                material = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)blockEntityTag.getCompound("Material"));
            }
            if (blockEntityTag.contains("Color", 3)) {
                colorSwapper = BufferModelUtils.getSwapper(DyeColor.byId((int)blockEntityTag.getInt("Color")));
            }
        }
        final BlockState finalMaterial = material;
        final UnaryOperator<TextureAtlasSprite> finalColorSwapper = colorSwapper;
        return List.of(new CopycatHeadstockModel(this.wrapped){

            @Override
            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
                List quads = finalColorSwapper != null ? BakedModelHelper.swapSprites((List)CopycatHeadstockModel.this.wrapped.getQuads(state, direction, random), (UnaryOperator)finalColorSwapper) : CopycatHeadstockModel.this.wrapped.getQuads(state, direction, random);
                ArrayList<BakedQuad> mutableQuads = new ArrayList<BakedQuad>(CopycatHeadstockModel.filterQuads(CopycatHeadstockModel::filterCopycatParts, quads));
                mutableQuads.addAll(this.getCroppedQuads(null, direction, random, finalMaterial, ModelData.EMPTY, null));
                return ImmutableList.copyOf(mutableQuads);
            }
        });
    }

    public boolean useAmbientOcclusion() {
        return this.wrapped.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.wrapped.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.wrapped.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.wrapped.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides getOverrides() {
        return this.wrapped.getOverrides();
    }

    public ItemTransforms getTransforms() {
        return this.wrapped.getTransforms();
    }

    private static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.get3DDataValue()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face == null ? false : this.occluded[face.get3DDataValue()];
        }
    }
}

