/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum HeadstockStyle implements StringRepresentable,
BlockStateBlockItemGroup.IStyle<Boolean>
{
    PLAIN("headstock", "Headstock"),
    BUFFER("headstock_buffer", "Headstock (Buffer)"),
    LINK("headstock_link_and_pin", "Headstock (Link 'n Pin)"),
    LINKLESS("headstock_link_and_pin_linkless", "Headstock (Linkless Link 'n Pin)"),
    KNUCKLE("headstock_knuckle_coupler", "Headstock (Knuckle Coupler)"),
    KNUCKLE_SPLIT("headstock_split_knuckle_coupler", "Headstock (Split Knuckle Coupler)"),
    SCREWLINK("headstock_screwlink_coupler", "Headstock (Screwlink Coupler)");

    private final String model;
    private final String langName;

    private HeadstockStyle(String model, String langName) {
        this.model = model;
        this.langName = langName;
    }

    public ResourceLocation getModel(boolean copycat, boolean upsideDown) {
        return Railways.asResource("block/buffer/headstock/" + (copycat ? "copycat_" : "wooden_") + this.model + (upsideDown ? "_upside_down" : ""));
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getLangName(Boolean copycat) {
        return (copycat != false ? "Copycat " : "Wooden ") + this.langName;
    }

    @Override
    public ResourceLocation getModel(Boolean context) {
        return this.getModel(context, false);
    }

    @Override
    public String getBlockId(Boolean context) {
        return (context != false ? "copycat_" : "wooden_") + this.model;
    }
}

