/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.BufferBlockPlaceContext;
import com.railwayteam.railways.content.buffer.NarrowTrackBufferBlock;
import com.railwayteam.railways.content.buffer.TrackBufferBlockEntity;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class TrackBufferBlock<BE extends TrackBufferBlockEntity>
extends HorizontalDirectionalBlock
implements IBE<BE>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty DIAGONAL = BooleanProperty.create((String)"diagonal");

    protected TrackBufferBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(false)));
    }

    public abstract Class<BE> getBlockEntityClass();

    public abstract BlockEntityType<? extends BE> getBlockEntityType();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED, DIAGONAL}));
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    protected abstract BlockState getCycledStyle(BlockState var1, Direction var2);

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.getAxis() == ((Direction)originalState.getValue((Property)FACING)).getAxis()) {
            return this.getCycledStyle(originalState, targetedFace);
        }
        return (BlockState)originalState.setValue((Property)FACING, (Comparable)((Direction)originalState.getValue((Property)FACING)).getOpposite());
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null && context instanceof BufferBlockPlaceContext) {
            BufferBlockPlaceContext bufferBlockPlaceContext = (BufferBlockPlaceContext)context;
            state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)bufferBlockPlaceContext.facing)).setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(bufferBlockPlaceContext.diagonal));
        }
        return this.withWater(state, context);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return CRBlocks.TRACK_BUFFER.asStack();
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        InteractionResult r = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyDyeIfValid(stack));
        return r.consumesAction() ? ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static int getBaseModelYRotationOf(BlockState state) {
        return TrackBufferBlock.getBaseModelYRotationOf(state, 0);
    }

    public static int getBaseModelYRotationOf(Direction facing) {
        return TrackBufferBlock.getBaseModelYRotationOf(facing, 0);
    }

    public static int getBaseModelYRotationOf(BlockState state, int offset) {
        return TrackBufferBlock.getBaseModelYRotationOf((Direction)state.getValue((Property)NarrowTrackBufferBlock.FACING), offset);
    }

    public static int getBaseModelYRotationOf(Direction facing, int offset) {
        return (int)(facing.toYRot() + 180.0f + (float)offset) % 360;
    }
}

