/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;

public final class MountedFuelTankSyncDeferral {
    private static final int TTL_TICKS = 200;
    private static final Map<Key, Pending> PENDING = new LinkedHashMap<Key, Pending>();

    private MountedFuelTankSyncDeferral() {
    }

    public static void defer(int entityId, BlockPos localPos, FluidStack fluid) {
        if (fluid == null) {
            return;
        }
        PENDING.put(new Key(entityId, localPos), new Pending(fluid.copy(), 200));
    }

    public static void clientTick(Minecraft mc, FuelTankApplier applier) {
        if (PENDING.isEmpty()) {
            return;
        }
        if (mc.level == null) {
            return;
        }
        Iterator<Map.Entry<Key, Pending>> iterator = PENDING.entrySet().iterator();
        while (iterator.hasNext()) {
            BlockEntity be;
            AbstractContraptionEntity ace;
            Contraption contraption;
            Map.Entry<Key, Pending> entry = iterator.next();
            Key key = entry.getKey();
            Pending pending = entry.getValue();
            Entity entity = mc.level.getEntity(key.entityId);
            if (entity instanceof AbstractContraptionEntity && (contraption = (ace = (AbstractContraptionEntity)entity).getContraption()) != null && (be = contraption.getOrCreateClientContraptionLazy().getBlockEntity(key.localPos)) != null && applier.tryApply(be, pending.fluid)) {
                iterator.remove();
                continue;
            }
            --pending.ticksRemaining;
            if (pending.ticksRemaining > 0) continue;
            iterator.remove();
        }
    }

    private record Key(int entityId, BlockPos localPos) {
        private Key {
            if (localPos == null) {
                throw new IllegalArgumentException("localPos cannot be null");
            }
        }
    }

    private static final class Pending {
        private final FluidStack fluid;
        private int ticksRemaining;

        private Pending(FluidStack fluid, int ticksRemaining) {
            this.fluid = fluid;
            this.ticksRemaining = ticksRemaining;
        }
    }

    @FunctionalInterface
    public static interface FuelTankApplier {
        public boolean tryApply(BlockEntity var1, FluidStack var2);
    }
}

