/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsPacket;
import com.simibubi.create.foundation.gui.widget.IconButton;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.eg.api.logistics.board.BasicPanelScreen;
import net.liukrast.eg.content.logistics.board.ComparatorMode;
import net.liukrast.eg.content.logistics.board.ComparatorPanelBehaviour;
import net.liukrast.eg.registry.EGPanelConnections;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public class ComparatorPanelScreen
extends BasicPanelScreen<ComparatorPanelBehaviour> {
    private int current;
    private IconButton[] buttons;

    public ComparatorPanelScreen(ComparatorPanelBehaviour behaviour) {
        super(behaviour);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.buttons = new IconButton[ComparatorMode.values().length];
        for (int i = 0; i < ComparatorMode.values().length; ++i) {
            ComparatorMode mode = ComparatorMode.values()[i];
            int fX = x + (this.windowWidth >> 1) + i * 32 - ComparatorMode.values().length * 16 + 3;
            IconButton button = new IconButton(fX, y + this.windowHeight / 3, (ScreenElement)mode.getIcon());
            int finalI = i;
            button.withCallback(() -> this.activateButton(finalI));
            button.setToolTip((Component)Component.translatable((String)mode.getTranslationKey()));
            if (((ComparatorPanelBehaviour)this.behaviour).comparatorMode == i) {
                button.setActive(false);
                this.current = i;
            }
            this.addRenderableWidget((GuiEventListener)button);
            this.buttons[i] = button;
        }
    }

    private void activateButton(int i) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ValueSettingsPacket(((ComparatorPanelBehaviour)this.behaviour).blockEntity.getBlockPos(), 2, i, null, null, Direction.UP, AllKeys.ctrlDown(), ((ComparatorPanelBehaviour)this.behaviour).netId()));
        for (IconButton button : this.buttons) {
            button.setActive(true);
        }
        this.buttons[i].setActive(false);
        this.current = i;
    }

    @Override
    public int getWindowHeight() {
        return 40;
    }

    @Override
    public int getWindowWidth() {
        return 100;
    }

    @Override
    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean value = ((ComparatorPanelBehaviour)this.behaviour).getConnectionValue(EGPanelConnections.REDSTONE).orElse(0) > 0;
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)((value ? "\u2714" : "\u2716") + " input " + ComparatorMode.values()[this.current].character() + " " + ((ComparatorPanelBehaviour)this.behaviour).value)), this.guiLeft + (this.windowWidth >> 1), this.guiTop + this.windowHeight - 21, 4013128);
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
    }
}

