/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightConfigScreen;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.OptionEnum;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).excludeFieldsWithModifiers(new int[]{16}).addSerializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    protected static final LinkedHashMap<String, EntryInfo> entries = new LinkedHashMap();
    public static final Map<String, MidnightConfig> configInstances = new HashMap<String, MidnightConfig>();
    protected String modid;
    protected boolean reloadScreen = false;
    public Class<? extends MidnightConfig> configClass;

    protected static <T extends MidnightConfig> T createInstance(String modid, Class<? extends MidnightConfig> configClass) {
        try {
            MidnightConfig instance = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.modid = modid;
            instance.configClass = configClass;
            configInstances.put(modid, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        Object instance = MidnightConfig.createInstance(modid, config);
        for (Field field : config.getFields()) {
            if (!field.isAnnotationPresent(Entry.class) && !field.isAnnotationPresent(Comment.class) || field.isAnnotationPresent(Server.class) || field.isAnnotationPresent(Hidden.class) || !PlatformFunctions.isClientEnv()) continue;
            ((MidnightConfig)instance).addClientEntry(field, new EntryInfo(field, modid));
        }
        ((MidnightConfig)instance).loadValuesFromJson();
    }

    protected void addClientEntry(Field field, EntryInfo info) {
        Entry e = info.entry;
        if (e != null && info.dataType != null) {
            if (info.dataType == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == ResourceLocation.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> this.getEnumTranslatableText(value, info);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.setValue(values.get(index >= values.size() ? 0 : index));
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        entries.put(this.modid + ":" + field.getName(), info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        Class rawType = field.getType();
        if (field.getType() == List.class) {
            rawType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        try {
            return (Class)rawType.getField("TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return rawType;
        }
    }

    protected static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches() || info.dataType == ResourceLocation.class && ResourceLocation.read((String)s).isError()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).withStyle(ChatFormatting.RED);
                t.setTooltip(info.getTooltip(true));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entries.values().stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == ResourceLocation.class) {
                    info.setValue(ResourceLocation.tryParse((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.entry.isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    protected Component getEnumTranslatableText(Object value, EntryInfo info) {
        if (value instanceof StringRepresentable) {
            StringRepresentable option = (StringRepresentable)value;
            return Component.translatable((String)option.getSerializedName());
        }
        if (value instanceof OptionEnum) {
            OptionEnum option = (OptionEnum)value;
            return option.getCaption();
        }
        assert (info.dataType != null);
        String translationKey = "%s.midnightconfig.enum.%s.%s".formatted(this.modid, info.dataType.getSimpleName(), info.toTemporaryValue());
        return I18n.exists((String)translationKey) ? Component.translatable((String)translationKey) : Component.literal((String)info.toTemporaryValue());
    }

    public void loadValuesFromJson() {
        try {
            gson.fromJson((Reader)Files.newBufferedReader(this.getJsonFilePath()), this.configClass);
        }
        catch (Exception e) {
            MidnightConfig.write(this.modid);
        }
        entries.values().forEach(info -> {
            if (info.field != null && info.entry != null) {
                try {
                    info.value = info.field.get(null) == null ? info.defaultValue : info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                    info.updateConditions();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
    }

    public static void write(String modid) {
        configInstances.get(modid).writeChanges(modid);
    }

    @Deprecated
    public void writeChanges(String modid) {
        this.writeChanges();
    }

    public void writeChanges() {
        try {
            Path path = this.getJsonFilePath();
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)this).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    public Path getJsonFilePath() {
        return PlatformFunctions.getConfigDirectory().resolve(this.modid + ".json");
    }

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        String key = modid + ":" + entry;
        return entries.containsKey(key) ? MidnightConfig.entries.get((Object)key).defaultValue : null;
    }

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Screen getScreen(Screen parent, String modid) {
        return configInstances.get(modid).getScreen(parent);
    }

    public MidnightConfigScreen getScreen(Screen parent) {
        return new MidnightConfigScreen(parent, this.modid);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";

        public String name() default "";

        public String url() default "";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Conditions {
        public Condition[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=Conditions.class)
    @Target(value={ElementType.FIELD})
    public static @interface Condition {
        public String requiredModId() default "";

        public String requiredOption() default "";

        public String[] requiredValue() default {"true"};

        public boolean visibleButLocked() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }
}

