/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientBoundOpenScreenMessage
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundOpenScreenMessage> TYPE = Message.makeType(Moonlight.res("s2c_open_screen"), ClientBoundOpenScreenMessage::new);
    public final TileOrEntityTarget target;
    private final Direction dir;
    private final Vec3 hit;

    public ClientBoundOpenScreenMessage(RegistryFriendlyByteBuf buffer) {
        this.target = TileOrEntityTarget.read((FriendlyByteBuf)buffer);
        this.dir = Direction.from3DDataValue((int)buffer.readVarInt());
        this.hit = buffer.readVec3();
    }

    public ClientBoundOpenScreenMessage(TileOrEntityTarget target, @Nullable Direction hitFace, Vec3 hitPos) {
        this.target = target;
        this.dir = hitFace == null ? Direction.UP : hitFace;
        this.hit = hitPos;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buffer) {
        this.target.write((FriendlyByteBuf)buffer);
        buffer.writeVarInt(this.dir.get3DDataValue());
        buffer.writeVec3(this.hit);
    }

    @Override
    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        Level level = player.level();
        Object object = this.target.getTarget(level);
        if (object instanceof IScreenProvider) {
            IScreenProvider tile = (IScreenProvider)object;
            tile.openScreen(level, player, this.dir, this.hit);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

